// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/generator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_TRACING_CONNECTION_H

#include "google/cloud/dialogflow_cx/generators_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class GeneratorsTracingConnection : public dialogflow_cx::GeneratorsConnection {
 public:
  ~GeneratorsTracingConnection() override = default;

  explicit GeneratorsTracingConnection(
      std::shared_ptr<dialogflow_cx::GeneratorsConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::dialogflow::cx::v3::Generator> ListGenerators(
      google::cloud::dialogflow::cx::v3::ListGeneratorsRequest request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> GetGenerator(
      google::cloud::dialogflow::cx::v3::GetGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> CreateGenerator(
      google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> UpdateGenerator(
      google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const& request)
      override;

  Status DeleteGenerator(
      google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const& request)
      override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<dialogflow_cx::GeneratorsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dialogflow_cx::GeneratorsConnection>
MakeGeneratorsTracingConnection(
    std::shared_ptr<dialogflow_cx::GeneratorsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_TRACING_CONNECTION_H
