// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/generator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_LOGGING_DECORATOR_H

#include "google/cloud/dialogflow_cx/internal/generators_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GeneratorsLogging : public GeneratorsStub {
 public:
  ~GeneratorsLogging() override = default;
  GeneratorsLogging(std::shared_ptr<GeneratorsStub> child,
                    TracingOptions tracing_options,
                    std::set<std::string> const& components);

  StatusOr<google::cloud::dialogflow::cx::v3::ListGeneratorsResponse>
  ListGenerators(grpc::ClientContext& context, Options const& options,
                 google::cloud::dialogflow::cx::v3::ListGeneratorsRequest const&
                     request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> GetGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::GetGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> CreateGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> UpdateGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const& request)
      override;

  Status DeleteGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<GeneratorsStub> child_;
  TracingOptions tracing_options_;
};  // GeneratorsLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_LOGGING_DECORATOR_H
