// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/entity_type.proto

#include "google/cloud/dialogflow_cx/internal/entity_types_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EntityTypesTracingConnection::EntityTypesTracingConnection(
    std::shared_ptr<dialogflow_cx::EntityTypesConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesTracingConnection::GetEntityType(
    google::cloud::dialogflow::cx::v3::GetEntityTypeRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::EntityTypesConnection::GetEntityType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEntityType(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesTracingConnection::CreateEntityType(
    google::cloud::dialogflow::cx::v3::CreateEntityTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::CreateEntityType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateEntityType(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesTracingConnection::UpdateEntityType(
    google::cloud::dialogflow::cx::v3::UpdateEntityTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::UpdateEntityType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateEntityType(request));
}

Status EntityTypesTracingConnection::DeleteEntityType(
    google::cloud::dialogflow::cx::v3::DeleteEntityTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::DeleteEntityType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteEntityType(request));
}

StreamRange<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesTracingConnection::ListEntityTypes(
    google::cloud::dialogflow::cx::v3::ListEntityTypesRequest request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ListEntityTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListEntityTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dialogflow::cx::v3::EntityType>(std::move(span),
                                                     std::move(sr));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportEntityTypesResponse>>
EntityTypesTracingConnection::ExportEntityTypes(
    google::cloud::dialogflow::cx::v3::ExportEntityTypesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ExportEntityTypes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportEntityTypes(request));
}

StatusOr<google::longrunning::Operation>
EntityTypesTracingConnection::ExportEntityTypes(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::ExportEntityTypesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ExportEntityTypes");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ExportEntityTypes(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ExportEntityTypesResponse>>
EntityTypesTracingConnection::ExportEntityTypes(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ExportEntityTypes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ExportEntityTypes(operation));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportEntityTypesResponse>>
EntityTypesTracingConnection::ImportEntityTypes(
    google::cloud::dialogflow::cx::v3::ImportEntityTypesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ImportEntityTypes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportEntityTypes(request));
}

StatusOr<google::longrunning::Operation>
EntityTypesTracingConnection::ImportEntityTypes(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::ImportEntityTypesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ImportEntityTypes");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ImportEntityTypes(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::ImportEntityTypesResponse>>
EntityTypesTracingConnection::ImportEntityTypes(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ImportEntityTypes");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ImportEntityTypes(operation));
}

StreamRange<google::cloud::location::Location>
EntityTypesTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::EntityTypesConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
EntityTypesTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::EntityTypesConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StreamRange<google::longrunning::Operation>
EntityTypesTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
EntityTypesTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::EntityTypesConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status EntityTypesTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::EntityTypesConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_cx::EntityTypesConnection>
MakeEntityTypesTracingConnection(
    std::shared_ptr<dialogflow_cx::EntityTypesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EntityTypesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
