// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/generator.proto

#include "google/cloud/dialogflow_cx/generators_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

GeneratorsConnectionIdempotencyPolicy::
    ~GeneratorsConnectionIdempotencyPolicy() = default;

std::unique_ptr<GeneratorsConnectionIdempotencyPolicy>
GeneratorsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<GeneratorsConnectionIdempotencyPolicy>(*this);
}

Idempotency GeneratorsConnectionIdempotencyPolicy::ListGenerators(
    google::cloud::dialogflow::cx::v3::ListGeneratorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::GetGenerator(
    google::cloud::dialogflow::cx::v3::GetGeneratorRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::CreateGenerator(
    google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::UpdateGenerator(
    google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::DeleteGenerator(
    google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GeneratorsConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<GeneratorsConnectionIdempotencyPolicy>
MakeDefaultGeneratorsConnectionIdempotencyPolicy() {
  return std::make_unique<GeneratorsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
