// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/experiment.proto

#include "google/cloud/dialogflow_cx/experiments_connection.h"
#include "google/cloud/dialogflow_cx/experiments_options.h"
#include "google/cloud/dialogflow_cx/internal/experiments_connection_impl.h"
#include "google/cloud/dialogflow_cx/internal/experiments_option_defaults.h"
#include "google/cloud/dialogflow_cx/internal/experiments_stub_factory.h"
#include "google/cloud/dialogflow_cx/internal/experiments_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExperimentsConnection::~ExperimentsConnection() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsConnection::ListExperiments(
    google::cloud::dialogflow::cx::v3::
        ListExperimentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dialogflow::cx::v3::Experiment>>();
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsConnection::GetExperiment(
    google::cloud::dialogflow::cx::v3::GetExperimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsConnection::CreateExperiment(
    google::cloud::dialogflow::cx::v3::CreateExperimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsConnection::UpdateExperiment(
    google::cloud::dialogflow::cx::v3::UpdateExperimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ExperimentsConnection::DeleteExperiment(
    google::cloud::dialogflow::cx::v3::DeleteExperimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsConnection::StartExperiment(
    google::cloud::dialogflow::cx::v3::StartExperimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::cx::v3::Experiment>
ExperimentsConnection::StopExperiment(
    google::cloud::dialogflow::cx::v3::StopExperimentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::location::Location>
ExperimentsConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location> ExperimentsConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
ExperimentsConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> ExperimentsConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ExperimentsConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ExperimentsConnection> MakeExperimentsConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ExperimentsPolicyOptionList>(options,
                                                              __func__);
  options = dialogflow_cx_internal::ExperimentsDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dialogflow_cx_internal::CreateDefaultExperimentsStub(
      std::move(auth), options);
  return dialogflow_cx_internal::MakeExperimentsTracingConnection(
      std::make_shared<dialogflow_cx_internal::ExperimentsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<ExperimentsConnection> MakeExperimentsConnection(
    Options options) {
  return MakeExperimentsConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
