// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#include "google/cloud/developerconnect/v1/internal/developer_connect_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace developerconnect_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DeveloperConnectTracingConnection::DeveloperConnectTracingConnection(
    std::shared_ptr<developerconnect_v1::DeveloperConnectConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::developerconnect::v1::Connection>
DeveloperConnectTracingConnection::ListConnections(
    google::cloud::developerconnect::v1::ListConnectionsRequest request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::ListConnections");
  internal::OTelScope scope(span);
  auto sr = child_->ListConnections(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::developerconnect::v1::Connection>(std::move(span),
                                                       std::move(sr));
}

StatusOr<google::cloud::developerconnect::v1::Connection>
DeveloperConnectTracingConnection::GetConnection(
    google::cloud::developerconnect::v1::GetConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::GetConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConnection(request));
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectTracingConnection::CreateConnection(
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::CreateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateConnection(request));
}

StatusOr<google::longrunning::Operation>
DeveloperConnectTracingConnection::CreateConnection(
    NoAwaitTag,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::CreateConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectTracingConnection::CreateConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::CreateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateConnection(operation));
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectTracingConnection::UpdateConnection(
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::UpdateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateConnection(request));
}

StatusOr<google::longrunning::Operation>
DeveloperConnectTracingConnection::UpdateConnection(
    NoAwaitTag,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::UpdateConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::developerconnect::v1::Connection>>
DeveloperConnectTracingConnection::UpdateConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::UpdateConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateConnection(operation));
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectTracingConnection::DeleteConnection(
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::DeleteConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteConnection(request));
}

StatusOr<google::longrunning::Operation>
DeveloperConnectTracingConnection::DeleteConnection(
    NoAwaitTag,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::DeleteConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectTracingConnection::DeleteConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::DeleteConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteConnection(operation));
}

future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
DeveloperConnectTracingConnection::CreateGitRepositoryLink(
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "CreateGitRepositoryLink");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateGitRepositoryLink(request));
}

StatusOr<google::longrunning::Operation>
DeveloperConnectTracingConnection::CreateGitRepositoryLink(
    NoAwaitTag,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "CreateGitRepositoryLink");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateGitRepositoryLink(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>>
DeveloperConnectTracingConnection::CreateGitRepositoryLink(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "CreateGitRepositoryLink");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateGitRepositoryLink(operation));
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectTracingConnection::DeleteGitRepositoryLink(
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "DeleteGitRepositoryLink");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteGitRepositoryLink(request));
}

StatusOr<google::longrunning::Operation>
DeveloperConnectTracingConnection::DeleteGitRepositoryLink(
    NoAwaitTag,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "DeleteGitRepositoryLink");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteGitRepositoryLink(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::developerconnect::v1::OperationMetadata>>
DeveloperConnectTracingConnection::DeleteGitRepositoryLink(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "DeleteGitRepositoryLink");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteGitRepositoryLink(operation));
}

StreamRange<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectTracingConnection::ListGitRepositoryLinks(
    google::cloud::developerconnect::v1::ListGitRepositoryLinksRequest
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "ListGitRepositoryLinks");
  internal::OTelScope scope(span);
  auto sr = child_->ListGitRepositoryLinks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::developerconnect::v1::GitRepositoryLink>(std::move(span),
                                                              std::move(sr));
}

StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectTracingConnection::GetGitRepositoryLink(
    google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::GetGitRepositoryLink");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGitRepositoryLink(request));
}

StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
DeveloperConnectTracingConnection::FetchReadWriteToken(
    google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::FetchReadWriteToken");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchReadWriteToken(request));
}

StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
DeveloperConnectTracingConnection::FetchReadToken(
    google::cloud::developerconnect::v1::FetchReadTokenRequest const& request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::FetchReadToken");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchReadToken(request));
}

StreamRange<google::cloud::developerconnect::v1::LinkableGitRepository>
DeveloperConnectTracingConnection::FetchLinkableGitRepositories(
    google::cloud::developerconnect::v1::FetchLinkableGitRepositoriesRequest
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "FetchLinkableGitRepositories");
  internal::OTelScope scope(span);
  auto sr = child_->FetchLinkableGitRepositories(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::developerconnect::v1::LinkableGitRepository>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
DeveloperConnectTracingConnection::FetchGitHubInstallations(
    google::cloud::developerconnect::v1::FetchGitHubInstallationsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::"
      "FetchGitHubInstallations");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchGitHubInstallations(request));
}

StreamRange<std::string> DeveloperConnectTracingConnection::FetchGitRefs(
    google::cloud::developerconnect::v1::FetchGitRefsRequest request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::FetchGitRefs");
  internal::OTelScope scope(span);
  auto sr = child_->FetchGitRefs(std::move(request));
  return internal::MakeTracedStreamRange<std::string>(std::move(span),
                                                      std::move(sr));
}

StreamRange<google::cloud::location::Location>
DeveloperConnectTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
DeveloperConnectTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StreamRange<google::longrunning::Operation>
DeveloperConnectTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
DeveloperConnectTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status DeveloperConnectTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status DeveloperConnectTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "developerconnect_v1::DeveloperConnectConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<developerconnect_v1::DeveloperConnectConnection>
MakeDeveloperConnectTracingConnection(
    std::shared_ptr<developerconnect_v1::DeveloperConnectConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DeveloperConnectTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1_internal
}  // namespace cloud
}  // namespace google
