// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#include "google/cloud/developerconnect/v1/internal/developer_connect_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/developerconnect/v1/developer_connect.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace developerconnect_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeveloperConnectLogging::DeveloperConnectLogging(
    std::shared_ptr<DeveloperConnectStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::developerconnect::v1::ListConnectionsResponse>
DeveloperConnectLogging::ListConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::ListConnectionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::ListConnectionsRequest const&
                 request) {
        return child_->ListConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::Connection>
DeveloperConnectLogging::GetConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::GetConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::GetConnectionRequest const&
                 request) {
        return child_->GetConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectLogging::AsyncCreateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::developerconnect::v1::CreateConnectionRequest const&
                 request) {
        return child_->AsyncCreateConnection(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectLogging::CreateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::CreateConnectionRequest const&
                 request) {
        return child_->CreateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectLogging::AsyncUpdateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::developerconnect::v1::UpdateConnectionRequest const&
                 request) {
        return child_->AsyncUpdateConnection(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectLogging::UpdateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::UpdateConnectionRequest const&
                 request) {
        return child_->UpdateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectLogging::AsyncDeleteConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::developerconnect::v1::DeleteConnectionRequest const&
                 request) {
        return child_->AsyncDeleteConnection(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectLogging::DeleteConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::DeleteConnectionRequest const&
                 request) {
        return child_->DeleteConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectLogging::AsyncCreateGitRepositoryLink(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::developerconnect::v1::
                 CreateGitRepositoryLinkRequest const& request) {
        return child_->AsyncCreateGitRepositoryLink(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectLogging::CreateGitRepositoryLink(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 CreateGitRepositoryLinkRequest const& request) {
        return child_->CreateGitRepositoryLink(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectLogging::AsyncDeleteGitRepositoryLink(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::developerconnect::v1::
                 DeleteGitRepositoryLinkRequest const& request) {
        return child_->AsyncDeleteGitRepositoryLink(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectLogging::DeleteGitRepositoryLink(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 DeleteGitRepositoryLinkRequest const& request) {
        return child_->DeleteGitRepositoryLink(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::ListGitRepositoryLinksResponse>
DeveloperConnectLogging::ListGitRepositoryLinks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::ListGitRepositoryLinksRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 ListGitRepositoryLinksRequest const& request) {
        return child_->ListGitRepositoryLinks(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectLogging::GetGitRepositoryLink(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 GetGitRepositoryLinkRequest const& request) {
        return child_->GetGitRepositoryLink(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
DeveloperConnectLogging::FetchReadWriteToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
              request) {
        return child_->FetchReadWriteToken(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
DeveloperConnectLogging::FetchReadToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchReadTokenRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::FetchReadTokenRequest const&
                 request) {
        return child_->FetchReadToken(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<
    google::cloud::developerconnect::v1::FetchLinkableGitRepositoriesResponse>
DeveloperConnectLogging::FetchLinkableGitRepositories(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::
        FetchLinkableGitRepositoriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 FetchLinkableGitRepositoriesRequest const& request) {
        return child_->FetchLinkableGitRepositories(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
DeveloperConnectLogging::FetchGitHubInstallations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchGitHubInstallationsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::
                 FetchGitHubInstallationsRequest const& request) {
        return child_->FetchGitHubInstallations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::developerconnect::v1::FetchGitRefsResponse>
DeveloperConnectLogging::FetchGitRefs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchGitRefsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::developerconnect::v1::FetchGitRefsRequest const&
                 request) {
        return child_->FetchGitRefs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::ListLocationsResponse>
DeveloperConnectLogging::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::ListLocationsRequest const& request) {
        return child_->ListLocations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::Location>
DeveloperConnectLogging::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return child_->GetLocation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::ListOperationsResponse>
DeveloperConnectLogging::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::ListOperationsRequest const& request) {
        return child_->ListOperations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::Operation> DeveloperConnectLogging::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->GetOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DeveloperConnectLogging::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return child_->DeleteOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status DeveloperConnectLogging::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->CancelOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> DeveloperConnectLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1_internal
}  // namespace cloud
}  // namespace google
