// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#include "google/cloud/developerconnect/v1/internal/developer_connect_auth_decorator.h"
#include <google/cloud/developerconnect/v1/developer_connect.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace developerconnect_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeveloperConnectAuth::DeveloperConnectAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DeveloperConnectStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::developerconnect::v1::ListConnectionsResponse>
DeveloperConnectAuth::ListConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::ListConnectionsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListConnections(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::Connection>
DeveloperConnectAuth::GetConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::GetConnectionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectAuth::AsyncCreateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateConnection(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> DeveloperConnectAuth::CreateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectAuth::AsyncUpdateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateConnection(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> DeveloperConnectAuth::UpdateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectAuth::AsyncDeleteConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteConnection(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> DeveloperConnectAuth::DeleteConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectAuth::AsyncCreateGitRepositoryLink(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateGitRepositoryLink(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DeveloperConnectAuth::CreateGitRepositoryLink(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateGitRepositoryLink(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectAuth::AsyncDeleteGitRepositoryLink(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteGitRepositoryLink(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DeveloperConnectAuth::DeleteGitRepositoryLink(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteGitRepositoryLink(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::ListGitRepositoryLinksResponse>
DeveloperConnectAuth::ListGitRepositoryLinks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::ListGitRepositoryLinksRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListGitRepositoryLinks(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectAuth::GetGitRepositoryLink(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetGitRepositoryLink(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
DeveloperConnectAuth::FetchReadWriteToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchReadWriteToken(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
DeveloperConnectAuth::FetchReadToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchReadTokenRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchReadToken(context, options, request);
}

StatusOr<
    google::cloud::developerconnect::v1::FetchLinkableGitRepositoriesResponse>
DeveloperConnectAuth::FetchLinkableGitRepositories(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::
        FetchLinkableGitRepositoriesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchLinkableGitRepositories(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
DeveloperConnectAuth::FetchGitHubInstallations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchGitHubInstallationsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchGitHubInstallations(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchGitRefsResponse>
DeveloperConnectAuth::FetchGitRefs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchGitRefsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchGitRefs(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
DeveloperConnectAuth::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location> DeveloperConnectAuth::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetLocation(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
DeveloperConnectAuth::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> DeveloperConnectAuth::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOperation(context, options, request);
}

Status DeveloperConnectAuth::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteOperation(context, options, request);
}

Status DeveloperConnectAuth::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CancelOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context),
                                        std::move(options), request);
      });
}

future<Status> DeveloperConnectAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context),
                                           std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1_internal
}  // namespace cloud
}  // namespace google
