// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/deploy/v1/cloud_deploy.proto

#include "google/cloud/deploy/v1/internal/cloud_deploy_connection_impl.h"
#include "google/cloud/deploy/v1/internal/cloud_deploy_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace deploy_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<deploy_v1::CloudDeployRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<deploy_v1::CloudDeployRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<deploy_v1::CloudDeployBackoffPolicyOption>()->clone();
}

std::unique_ptr<deploy_v1::CloudDeployConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<deploy_v1::CloudDeployConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<deploy_v1::CloudDeployPollingPolicyOption>()->clone();
}

}  // namespace

CloudDeployConnectionImpl::CloudDeployConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<deploy_v1_internal::CloudDeployStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      CloudDeployConnection::options())) {}

StreamRange<google::cloud::deploy::v1::DeliveryPipeline>
CloudDeployConnectionImpl::ListDeliveryPipelines(
    google::cloud::deploy::v1::ListDeliveryPipelinesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDeliveryPipelines(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::DeliveryPipeline>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListDeliveryPipelinesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::deploy::v1::ListDeliveryPipelinesRequest const&
                    request) {
              return stub->ListDeliveryPipelines(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListDeliveryPipelinesResponse r) {
        std::vector<google::cloud::deploy::v1::DeliveryPipeline> result(
            r.delivery_pipelines().size());
        auto& messages = *r.mutable_delivery_pipelines();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::DeliveryPipeline>
CloudDeployConnectionImpl::GetDeliveryPipeline(
    google::cloud::deploy::v1::GetDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDeliveryPipeline(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetDeliveryPipelineRequest const&
                 request) {
        return stub_->GetDeliveryPipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnectionImpl::CreateDeliveryPipeline(
    google::cloud::deploy::v1::CreateDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDeliveryPipeline(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::DeliveryPipeline>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateDeliveryPipelineRequest const&
              request) {
        return stub->AsyncCreateDeliveryPipeline(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeliveryPipeline>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateDeliveryPipeline(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDeliveryPipeline(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CreateDeliveryPipelineRequest const&
                 request) {
        return stub_->CreateDeliveryPipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnectionImpl::CreateDeliveryPipeline(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDeliveryPipeline",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::DeliveryPipeline>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeliveryPipeline>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnectionImpl::UpdateDeliveryPipeline(
    google::cloud::deploy::v1::UpdateDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateDeliveryPipeline(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::DeliveryPipeline>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::UpdateDeliveryPipelineRequest const&
              request) {
        return stub->AsyncUpdateDeliveryPipeline(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeliveryPipeline>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::UpdateDeliveryPipeline(
    NoAwaitTag,
    google::cloud::deploy::v1::UpdateDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDeliveryPipeline(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::UpdateDeliveryPipelineRequest const&
                 request) {
        return stub_->UpdateDeliveryPipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnectionImpl::UpdateDeliveryPipeline(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateDeliveryPipeline",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::DeliveryPipeline>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeliveryPipeline>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteDeliveryPipeline(
    google::cloud::deploy::v1::DeleteDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDeliveryPipeline(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::DeleteDeliveryPipelineRequest const&
              request) {
        return stub->AsyncDeleteDeliveryPipeline(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::DeleteDeliveryPipeline(
    NoAwaitTag,
    google::cloud::deploy::v1::DeleteDeliveryPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDeliveryPipeline(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::DeleteDeliveryPipelineRequest const&
                 request) {
        return stub_->DeleteDeliveryPipeline(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteDeliveryPipeline(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDeliveryPipeline",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::deploy::v1::Target>
CloudDeployConnectionImpl::ListTargets(
    google::cloud::deploy::v1::ListTargetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTargets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::Target>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListTargetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::deploy::v1::ListTargetsRequest const& request) {
              return stub->ListTargets(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListTargetsResponse r) {
        std::vector<google::cloud::deploy::v1::Target> result(
            r.targets().size());
        auto& messages = *r.mutable_targets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::RollbackTargetResponse>
CloudDeployConnectionImpl::RollbackTarget(
    google::cloud::deploy::v1::RollbackTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RollbackTarget(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::RollbackTargetRequest const& request) {
        return stub_->RollbackTarget(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::Target>
CloudDeployConnectionImpl::GetTarget(
    google::cloud::deploy::v1::GetTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTarget(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetTargetRequest const& request) {
        return stub_->GetTarget(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnectionImpl::CreateTarget(
    google::cloud::deploy::v1::CreateTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateTarget(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::Target>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateTargetRequest const& request) {
        return stub->AsyncCreateTarget(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Target>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateTarget(
    NoAwaitTag, google::cloud::deploy::v1::CreateTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTarget(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CreateTargetRequest const& request) {
        return stub_->CreateTarget(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnectionImpl::CreateTarget(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::Target>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateTarget",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::Target>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Target>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnectionImpl::UpdateTarget(
    google::cloud::deploy::v1::UpdateTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateTarget(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::Target>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::UpdateTargetRequest const& request) {
        return stub->AsyncUpdateTarget(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Target>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::UpdateTarget(
    NoAwaitTag, google::cloud::deploy::v1::UpdateTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTarget(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::UpdateTargetRequest const& request) {
        return stub_->UpdateTarget(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnectionImpl::UpdateTarget(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::Target>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateTarget",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::Target>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Target>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteTarget(
    google::cloud::deploy::v1::DeleteTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteTarget(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::DeleteTargetRequest const& request) {
        return stub->AsyncDeleteTarget(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::DeleteTarget(
    NoAwaitTag, google::cloud::deploy::v1::DeleteTargetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTarget(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::DeleteTargetRequest const& request) {
        return stub_->DeleteTarget(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteTarget(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteTarget",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::deploy::v1::CustomTargetType>
CloudDeployConnectionImpl::ListCustomTargetTypes(
    google::cloud::deploy::v1::ListCustomTargetTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCustomTargetTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::CustomTargetType>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListCustomTargetTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::deploy::v1::ListCustomTargetTypesRequest const&
                    request) {
              return stub->ListCustomTargetTypes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListCustomTargetTypesResponse r) {
        std::vector<google::cloud::deploy::v1::CustomTargetType> result(
            r.custom_target_types().size());
        auto& messages = *r.mutable_custom_target_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::CustomTargetType>
CloudDeployConnectionImpl::GetCustomTargetType(
    google::cloud::deploy::v1::GetCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCustomTargetType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetCustomTargetTypeRequest const&
                 request) {
        return stub_->GetCustomTargetType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnectionImpl::CreateCustomTargetType(
    google::cloud::deploy::v1::CreateCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateCustomTargetType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::CustomTargetType>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateCustomTargetTypeRequest const&
              request) {
        return stub->AsyncCreateCustomTargetType(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::CustomTargetType>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateCustomTargetType(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCustomTargetType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CreateCustomTargetTypeRequest const&
                 request) {
        return stub_->CreateCustomTargetType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnectionImpl::CreateCustomTargetType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::CustomTargetType>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateCustomTargetType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::CustomTargetType>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::CustomTargetType>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnectionImpl::UpdateCustomTargetType(
    google::cloud::deploy::v1::UpdateCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateCustomTargetType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::CustomTargetType>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::UpdateCustomTargetTypeRequest const&
              request) {
        return stub->AsyncUpdateCustomTargetType(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::CustomTargetType>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::UpdateCustomTargetType(
    NoAwaitTag,
    google::cloud::deploy::v1::UpdateCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCustomTargetType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::UpdateCustomTargetTypeRequest const&
                 request) {
        return stub_->UpdateCustomTargetType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnectionImpl::UpdateCustomTargetType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::CustomTargetType>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateCustomTargetType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::CustomTargetType>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::CustomTargetType>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteCustomTargetType(
    google::cloud::deploy::v1::DeleteCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteCustomTargetType(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::DeleteCustomTargetTypeRequest const&
              request) {
        return stub->AsyncDeleteCustomTargetType(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::DeleteCustomTargetType(
    NoAwaitTag,
    google::cloud::deploy::v1::DeleteCustomTargetTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCustomTargetType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::DeleteCustomTargetTypeRequest const&
                 request) {
        return stub_->DeleteCustomTargetType(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteCustomTargetType(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteCustomTargetType",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::deploy::v1::Release>
CloudDeployConnectionImpl::ListReleases(
    google::cloud::deploy::v1::ListReleasesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReleases(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::Release>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListReleasesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::deploy::v1::ListReleasesRequest const& request) {
              return stub->ListReleases(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListReleasesResponse r) {
        std::vector<google::cloud::deploy::v1::Release> result(
            r.releases().size());
        auto& messages = *r.mutable_releases();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::Release>
CloudDeployConnectionImpl::GetRelease(
    google::cloud::deploy::v1::GetReleaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRelease(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetReleaseRequest const& request) {
        return stub_->GetRelease(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Release>>
CloudDeployConnectionImpl::CreateRelease(
    google::cloud::deploy::v1::CreateReleaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateRelease(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::Release>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateReleaseRequest const& request) {
        return stub->AsyncCreateRelease(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Release>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateRelease(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateReleaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateRelease(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CreateReleaseRequest const& request) {
        return stub_->CreateRelease(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Release>>
CloudDeployConnectionImpl::CreateRelease(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::Release>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateRelease",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::Release>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Release>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::deploy::v1::AbandonReleaseResponse>
CloudDeployConnectionImpl::AbandonRelease(
    google::cloud::deploy::v1::AbandonReleaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AbandonRelease(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::AbandonReleaseRequest const& request) {
        return stub_->AbandonRelease(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnectionImpl::CreateDeployPolicy(
    google::cloud::deploy::v1::CreateDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDeployPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::DeployPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateDeployPolicyRequest const& request) {
        return stub->AsyncCreateDeployPolicy(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeployPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateDeployPolicy(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDeployPolicy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::CreateDeployPolicyRequest const& request) {
        return stub_->CreateDeployPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnectionImpl::CreateDeployPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDeployPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::DeployPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeployPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnectionImpl::UpdateDeployPolicy(
    google::cloud::deploy::v1::UpdateDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateDeployPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::DeployPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::UpdateDeployPolicyRequest const& request) {
        return stub->AsyncUpdateDeployPolicy(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeployPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::UpdateDeployPolicy(
    NoAwaitTag,
    google::cloud::deploy::v1::UpdateDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDeployPolicy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::UpdateDeployPolicyRequest const& request) {
        return stub_->UpdateDeployPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnectionImpl::UpdateDeployPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateDeployPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::DeployPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::DeployPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteDeployPolicy(
    google::cloud::deploy::v1::DeleteDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDeployPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::DeleteDeployPolicyRequest const& request) {
        return stub->AsyncDeleteDeployPolicy(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::DeleteDeployPolicy(
    NoAwaitTag,
    google::cloud::deploy::v1::DeleteDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDeployPolicy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::DeleteDeployPolicyRequest const& request) {
        return stub_->DeleteDeployPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteDeployPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDeployPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::deploy::v1::DeployPolicy>
CloudDeployConnectionImpl::ListDeployPolicies(
    google::cloud::deploy::v1::ListDeployPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDeployPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::DeployPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListDeployPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::deploy::v1::ListDeployPoliciesRequest const&
                       request) {
              return stub->ListDeployPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListDeployPoliciesResponse r) {
        std::vector<google::cloud::deploy::v1::DeployPolicy> result(
            r.deploy_policies().size());
        auto& messages = *r.mutable_deploy_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::DeployPolicy>
CloudDeployConnectionImpl::GetDeployPolicy(
    google::cloud::deploy::v1::GetDeployPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDeployPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetDeployPolicyRequest const& request) {
        return stub_->GetDeployPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::ApproveRolloutResponse>
CloudDeployConnectionImpl::ApproveRollout(
    google::cloud::deploy::v1::ApproveRolloutRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ApproveRollout(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::ApproveRolloutRequest const& request) {
        return stub_->ApproveRollout(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::AdvanceRolloutResponse>
CloudDeployConnectionImpl::AdvanceRollout(
    google::cloud::deploy::v1::AdvanceRolloutRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AdvanceRollout(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::AdvanceRolloutRequest const& request) {
        return stub_->AdvanceRollout(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::CancelRolloutResponse>
CloudDeployConnectionImpl::CancelRollout(
    google::cloud::deploy::v1::CancelRolloutRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelRollout(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CancelRolloutRequest const& request) {
        return stub_->CancelRollout(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::deploy::v1::Rollout>
CloudDeployConnectionImpl::ListRollouts(
    google::cloud::deploy::v1::ListRolloutsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListRollouts(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::Rollout>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListRolloutsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::deploy::v1::ListRolloutsRequest const& request) {
              return stub->ListRollouts(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListRolloutsResponse r) {
        std::vector<google::cloud::deploy::v1::Rollout> result(
            r.rollouts().size());
        auto& messages = *r.mutable_rollouts();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::Rollout>
CloudDeployConnectionImpl::GetRollout(
    google::cloud::deploy::v1::GetRolloutRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRollout(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetRolloutRequest const& request) {
        return stub_->GetRollout(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Rollout>>
CloudDeployConnectionImpl::CreateRollout(
    google::cloud::deploy::v1::CreateRolloutRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateRollout(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::Rollout>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateRolloutRequest const& request) {
        return stub->AsyncCreateRollout(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Rollout>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateRollout(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateRolloutRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateRollout(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CreateRolloutRequest const& request) {
        return stub_->CreateRollout(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Rollout>>
CloudDeployConnectionImpl::CreateRollout(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::Rollout>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateRollout",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::Rollout>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Rollout>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::deploy::v1::IgnoreJobResponse>
CloudDeployConnectionImpl::IgnoreJob(
    google::cloud::deploy::v1::IgnoreJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->IgnoreJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::IgnoreJobRequest const& request) {
        return stub_->IgnoreJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::RetryJobResponse>
CloudDeployConnectionImpl::RetryJob(
    google::cloud::deploy::v1::RetryJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RetryJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::RetryJobRequest const& request) {
        return stub_->RetryJob(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::deploy::v1::JobRun>
CloudDeployConnectionImpl::ListJobRuns(
    google::cloud::deploy::v1::ListJobRunsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobRuns(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::JobRun>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListJobRunsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::deploy::v1::ListJobRunsRequest const& request) {
              return stub->ListJobRuns(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListJobRunsResponse r) {
        std::vector<google::cloud::deploy::v1::JobRun> result(
            r.job_runs().size());
        auto& messages = *r.mutable_job_runs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::JobRun>
CloudDeployConnectionImpl::GetJobRun(
    google::cloud::deploy::v1::GetJobRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJobRun(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetJobRunRequest const& request) {
        return stub_->GetJobRun(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::TerminateJobRunResponse>
CloudDeployConnectionImpl::TerminateJobRun(
    google::cloud::deploy::v1::TerminateJobRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TerminateJobRun(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::TerminateJobRunRequest const& request) {
        return stub_->TerminateJobRun(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::deploy::v1::Config>
CloudDeployConnectionImpl::GetConfig(
    google::cloud::deploy::v1::GetConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConfig(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetConfigRequest const& request) {
        return stub_->GetConfig(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnectionImpl::CreateAutomation(
    google::cloud::deploy::v1::CreateAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateAutomation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::Automation>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::CreateAutomationRequest const& request) {
        return stub->AsyncCreateAutomation(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Automation>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::CreateAutomation(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAutomation(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::CreateAutomationRequest const& request) {
        return stub_->CreateAutomation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnectionImpl::CreateAutomation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::Automation>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateAutomation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::Automation>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Automation>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnectionImpl::UpdateAutomation(
    google::cloud::deploy::v1::UpdateAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateAutomation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::Automation>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::UpdateAutomationRequest const& request) {
        return stub->AsyncUpdateAutomation(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Automation>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::UpdateAutomation(
    NoAwaitTag,
    google::cloud::deploy::v1::UpdateAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAutomation(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::UpdateAutomationRequest const& request) {
        return stub_->UpdateAutomation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnectionImpl::UpdateAutomation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::deploy::v1::Automation>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateAutomation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::Automation>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::deploy::v1::Automation>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteAutomation(
    google::cloud::deploy::v1::DeleteAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteAutomation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::deploy::v1::DeleteAutomationRequest const& request) {
        return stub->AsyncDeleteAutomation(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::DeleteAutomation(
    NoAwaitTag,
    google::cloud::deploy::v1::DeleteAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAutomation(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::DeleteAutomationRequest const& request) {
        return stub_->DeleteAutomation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnectionImpl::DeleteAutomation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::deploy::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteAutomation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::deploy::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::deploy::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::deploy::v1::Automation>
CloudDeployConnectionImpl::GetAutomation(
    google::cloud::deploy::v1::GetAutomationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAutomation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::GetAutomationRequest const& request) {
        return stub_->GetAutomation(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::deploy::v1::Automation>
CloudDeployConnectionImpl::ListAutomations(
    google::cloud::deploy::v1::ListAutomationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAutomations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::Automation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListAutomationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::deploy::v1::ListAutomationsRequest const&
                       request) {
              return stub->ListAutomations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListAutomationsResponse r) {
        std::vector<google::cloud::deploy::v1::Automation> result(
            r.automations().size());
        auto& messages = *r.mutable_automations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::AutomationRun>
CloudDeployConnectionImpl::GetAutomationRun(
    google::cloud::deploy::v1::GetAutomationRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAutomationRun(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::deploy::v1::GetAutomationRunRequest const& request) {
        return stub_->GetAutomationRun(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::deploy::v1::AutomationRun>
CloudDeployConnectionImpl::ListAutomationRuns(
    google::cloud::deploy::v1::ListAutomationRunsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAutomationRuns(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::deploy::v1::AutomationRun>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::deploy::v1::ListAutomationRunsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::deploy::v1::ListAutomationRunsRequest const&
                       request) {
              return stub->ListAutomationRuns(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::deploy::v1::ListAutomationRunsResponse r) {
        std::vector<google::cloud::deploy::v1::AutomationRun> result(
            r.automation_runs().size());
        auto& messages = *r.mutable_automation_runs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::deploy::v1::CancelAutomationRunResponse>
CloudDeployConnectionImpl::CancelAutomationRun(
    google::cloud::deploy::v1::CancelAutomationRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelAutomationRun(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::deploy::v1::CancelAutomationRunRequest const&
                 request) {
        return stub_->CancelAutomationRun(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::location::Location>
CloudDeployConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
CloudDeployConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> CloudDeployConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> CloudDeployConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudDeployConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
CloudDeployConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<deploy_v1::CloudDeployRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
CloudDeployConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status CloudDeployConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status CloudDeployConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace deploy_v1_internal
}  // namespace cloud
}  // namespace google
