// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/deploy/v1/cloud_deploy.proto

#include "google/cloud/deploy/v1/cloud_deploy_connection.h"
#include "google/cloud/deploy/v1/cloud_deploy_options.h"
#include "google/cloud/deploy/v1/internal/cloud_deploy_connection_impl.h"
#include "google/cloud/deploy/v1/internal/cloud_deploy_option_defaults.h"
#include "google/cloud/deploy/v1/internal/cloud_deploy_stub_factory.h"
#include "google/cloud/deploy/v1/internal/cloud_deploy_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace deploy_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudDeployConnection::~CloudDeployConnection() = default;

StreamRange<google::cloud::deploy::v1::DeliveryPipeline>
CloudDeployConnection::ListDeliveryPipelines(
    google::cloud::deploy::v1::
        ListDeliveryPipelinesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::DeliveryPipeline>>();
}

StatusOr<google::cloud::deploy::v1::DeliveryPipeline>
CloudDeployConnection::GetDeliveryPipeline(
    google::cloud::deploy::v1::GetDeliveryPipelineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnection::CreateDeliveryPipeline(
    google::cloud::deploy::v1::CreateDeliveryPipelineRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::CreateDeliveryPipeline(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateDeliveryPipelineRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnection::CreateDeliveryPipeline(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnection::UpdateDeliveryPipeline(
    google::cloud::deploy::v1::UpdateDeliveryPipelineRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::UpdateDeliveryPipeline(
    NoAwaitTag,
    google::cloud::deploy::v1::UpdateDeliveryPipelineRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>
CloudDeployConnection::UpdateDeliveryPipeline(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeliveryPipeline>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteDeliveryPipeline(
    google::cloud::deploy::v1::DeleteDeliveryPipelineRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::DeleteDeliveryPipeline(
    NoAwaitTag,
    google::cloud::deploy::v1::DeleteDeliveryPipelineRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteDeliveryPipeline(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::deploy::v1::Target>
CloudDeployConnection::ListTargets(
    google::cloud::deploy::v1::
        ListTargetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::Target>>();
}

StatusOr<google::cloud::deploy::v1::RollbackTargetResponse>
CloudDeployConnection::RollbackTarget(
    google::cloud::deploy::v1::RollbackTargetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::Target> CloudDeployConnection::GetTarget(
    google::cloud::deploy::v1::GetTargetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnection::CreateTarget(
    google::cloud::deploy::v1::CreateTargetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Target>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> CloudDeployConnection::CreateTarget(
    NoAwaitTag, google::cloud::deploy::v1::CreateTargetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnection::CreateTarget(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Target>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnection::UpdateTarget(
    google::cloud::deploy::v1::UpdateTargetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Target>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> CloudDeployConnection::UpdateTarget(
    NoAwaitTag, google::cloud::deploy::v1::UpdateTargetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Target>>
CloudDeployConnection::UpdateTarget(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Target>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteTarget(
    google::cloud::deploy::v1::DeleteTargetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> CloudDeployConnection::DeleteTarget(
    NoAwaitTag, google::cloud::deploy::v1::DeleteTargetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteTarget(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::deploy::v1::CustomTargetType>
CloudDeployConnection::ListCustomTargetTypes(
    google::cloud::deploy::v1::
        ListCustomTargetTypesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::CustomTargetType>>();
}

StatusOr<google::cloud::deploy::v1::CustomTargetType>
CloudDeployConnection::GetCustomTargetType(
    google::cloud::deploy::v1::GetCustomTargetTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnection::CreateCustomTargetType(
    google::cloud::deploy::v1::CreateCustomTargetTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::CustomTargetType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::CreateCustomTargetType(
    NoAwaitTag,
    google::cloud::deploy::v1::CreateCustomTargetTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnection::CreateCustomTargetType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::CustomTargetType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnection::UpdateCustomTargetType(
    google::cloud::deploy::v1::UpdateCustomTargetTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::CustomTargetType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::UpdateCustomTargetType(
    NoAwaitTag,
    google::cloud::deploy::v1::UpdateCustomTargetTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::CustomTargetType>>
CloudDeployConnection::UpdateCustomTargetType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::CustomTargetType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteCustomTargetType(
    google::cloud::deploy::v1::DeleteCustomTargetTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::DeleteCustomTargetType(
    NoAwaitTag,
    google::cloud::deploy::v1::DeleteCustomTargetTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteCustomTargetType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::deploy::v1::Release>
CloudDeployConnection::ListReleases(
    google::cloud::deploy::v1::
        ListReleasesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::Release>>();
}

StatusOr<google::cloud::deploy::v1::Release> CloudDeployConnection::GetRelease(
    google::cloud::deploy::v1::GetReleaseRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::Release>>
CloudDeployConnection::CreateRelease(
    google::cloud::deploy::v1::CreateReleaseRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Release>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> CloudDeployConnection::CreateRelease(
    NoAwaitTag, google::cloud::deploy::v1::CreateReleaseRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Release>>
CloudDeployConnection::CreateRelease(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Release>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::deploy::v1::AbandonReleaseResponse>
CloudDeployConnection::AbandonRelease(
    google::cloud::deploy::v1::AbandonReleaseRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnection::CreateDeployPolicy(
    google::cloud::deploy::v1::CreateDeployPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeployPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::CreateDeployPolicy(
    NoAwaitTag, google::cloud::deploy::v1::CreateDeployPolicyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnection::CreateDeployPolicy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeployPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnection::UpdateDeployPolicy(
    google::cloud::deploy::v1::UpdateDeployPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeployPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::UpdateDeployPolicy(
    NoAwaitTag, google::cloud::deploy::v1::UpdateDeployPolicyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::DeployPolicy>>
CloudDeployConnection::UpdateDeployPolicy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::DeployPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteDeployPolicy(
    google::cloud::deploy::v1::DeleteDeployPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::DeleteDeployPolicy(
    NoAwaitTag, google::cloud::deploy::v1::DeleteDeployPolicyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteDeployPolicy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::deploy::v1::DeployPolicy>
CloudDeployConnection::ListDeployPolicies(
    google::cloud::deploy::v1::
        ListDeployPoliciesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::DeployPolicy>>();
}

StatusOr<google::cloud::deploy::v1::DeployPolicy>
CloudDeployConnection::GetDeployPolicy(
    google::cloud::deploy::v1::GetDeployPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::ApproveRolloutResponse>
CloudDeployConnection::ApproveRollout(
    google::cloud::deploy::v1::ApproveRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::AdvanceRolloutResponse>
CloudDeployConnection::AdvanceRollout(
    google::cloud::deploy::v1::AdvanceRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::CancelRolloutResponse>
CloudDeployConnection::CancelRollout(
    google::cloud::deploy::v1::CancelRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::deploy::v1::Rollout>
CloudDeployConnection::ListRollouts(
    google::cloud::deploy::v1::
        ListRolloutsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::Rollout>>();
}

StatusOr<google::cloud::deploy::v1::Rollout> CloudDeployConnection::GetRollout(
    google::cloud::deploy::v1::GetRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::Rollout>>
CloudDeployConnection::CreateRollout(
    google::cloud::deploy::v1::CreateRolloutRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Rollout>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> CloudDeployConnection::CreateRollout(
    NoAwaitTag, google::cloud::deploy::v1::CreateRolloutRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Rollout>>
CloudDeployConnection::CreateRollout(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Rollout>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::deploy::v1::IgnoreJobResponse>
CloudDeployConnection::IgnoreJob(
    google::cloud::deploy::v1::IgnoreJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::RetryJobResponse>
CloudDeployConnection::RetryJob(
    google::cloud::deploy::v1::RetryJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::deploy::v1::JobRun>
CloudDeployConnection::ListJobRuns(
    google::cloud::deploy::v1::
        ListJobRunsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::JobRun>>();
}

StatusOr<google::cloud::deploy::v1::JobRun> CloudDeployConnection::GetJobRun(
    google::cloud::deploy::v1::GetJobRunRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::TerminateJobRunResponse>
CloudDeployConnection::TerminateJobRun(
    google::cloud::deploy::v1::TerminateJobRunRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::deploy::v1::Config> CloudDeployConnection::GetConfig(
    google::cloud::deploy::v1::GetConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnection::CreateAutomation(
    google::cloud::deploy::v1::CreateAutomationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Automation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::CreateAutomation(
    NoAwaitTag, google::cloud::deploy::v1::CreateAutomationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnection::CreateAutomation(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Automation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnection::UpdateAutomation(
    google::cloud::deploy::v1::UpdateAutomationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Automation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::UpdateAutomation(
    NoAwaitTag, google::cloud::deploy::v1::UpdateAutomationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::Automation>>
CloudDeployConnection::UpdateAutomation(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::Automation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteAutomation(
    google::cloud::deploy::v1::DeleteAutomationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudDeployConnection::DeleteAutomation(
    NoAwaitTag, google::cloud::deploy::v1::DeleteAutomationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::deploy::v1::OperationMetadata>>
CloudDeployConnection::DeleteAutomation(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::deploy::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::deploy::v1::Automation>
CloudDeployConnection::GetAutomation(
    google::cloud::deploy::v1::GetAutomationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::deploy::v1::Automation>
CloudDeployConnection::ListAutomations(
    google::cloud::deploy::v1::
        ListAutomationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::Automation>>();
}

StatusOr<google::cloud::deploy::v1::AutomationRun>
CloudDeployConnection::GetAutomationRun(
    google::cloud::deploy::v1::GetAutomationRunRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::deploy::v1::AutomationRun>
CloudDeployConnection::ListAutomationRuns(
    google::cloud::deploy::v1::
        ListAutomationRunsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::deploy::v1::AutomationRun>>();
}

StatusOr<google::cloud::deploy::v1::CancelAutomationRunResponse>
CloudDeployConnection::CancelAutomationRun(
    google::cloud::deploy::v1::CancelAutomationRunRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::location::Location>
CloudDeployConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location> CloudDeployConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudDeployConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudDeployConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudDeployConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
CloudDeployConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> CloudDeployConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status CloudDeployConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status CloudDeployConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CloudDeployConnection> MakeCloudDeployConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 CloudDeployPolicyOptionList>(options,
                                                              __func__);
  options = deploy_v1_internal::CloudDeployDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = deploy_v1_internal::CreateDefaultCloudDeployStub(std::move(auth),
                                                               options);
  return deploy_v1_internal::MakeCloudDeployTracingConnection(
      std::make_shared<deploy_v1_internal::CloudDeployConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace deploy_v1
}  // namespace cloud
}  // namespace google
