// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datastream/v1/datastream.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTREAM_V1_DATASTREAM_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTREAM_V1_DATASTREAM_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/datastream/v1/datastream.grpc.pb.h>
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datastream_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatastreamConnectionIdempotencyPolicy {
 public:
  virtual ~DatastreamConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DatastreamConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency ListConnectionProfiles(
      google::cloud::datastream::v1::ListConnectionProfilesRequest request);

  virtual google::cloud::Idempotency GetConnectionProfile(
      google::cloud::datastream::v1::GetConnectionProfileRequest const&
          request);

  virtual google::cloud::Idempotency CreateConnectionProfile(
      google::cloud::datastream::v1::CreateConnectionProfileRequest const&
          request);

  virtual google::cloud::Idempotency UpdateConnectionProfile(
      google::cloud::datastream::v1::UpdateConnectionProfileRequest const&
          request);

  virtual google::cloud::Idempotency DeleteConnectionProfile(
      google::cloud::datastream::v1::DeleteConnectionProfileRequest const&
          request);

  virtual google::cloud::Idempotency DiscoverConnectionProfile(
      google::cloud::datastream::v1::DiscoverConnectionProfileRequest const&
          request);

  virtual google::cloud::Idempotency ListStreams(
      google::cloud::datastream::v1::ListStreamsRequest request);

  virtual google::cloud::Idempotency GetStream(
      google::cloud::datastream::v1::GetStreamRequest const& request);

  virtual google::cloud::Idempotency CreateStream(
      google::cloud::datastream::v1::CreateStreamRequest const& request);

  virtual google::cloud::Idempotency UpdateStream(
      google::cloud::datastream::v1::UpdateStreamRequest const& request);

  virtual google::cloud::Idempotency DeleteStream(
      google::cloud::datastream::v1::DeleteStreamRequest const& request);

  virtual google::cloud::Idempotency GetStreamObject(
      google::cloud::datastream::v1::GetStreamObjectRequest const& request);

  virtual google::cloud::Idempotency LookupStreamObject(
      google::cloud::datastream::v1::LookupStreamObjectRequest const& request);

  virtual google::cloud::Idempotency ListStreamObjects(
      google::cloud::datastream::v1::ListStreamObjectsRequest request);

  virtual google::cloud::Idempotency StartBackfillJob(
      google::cloud::datastream::v1::StartBackfillJobRequest const& request);

  virtual google::cloud::Idempotency StopBackfillJob(
      google::cloud::datastream::v1::StopBackfillJobRequest const& request);

  virtual google::cloud::Idempotency FetchStaticIps(
      google::cloud::datastream::v1::FetchStaticIpsRequest request);

  virtual google::cloud::Idempotency CreatePrivateConnection(
      google::cloud::datastream::v1::CreatePrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency GetPrivateConnection(
      google::cloud::datastream::v1::GetPrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency ListPrivateConnections(
      google::cloud::datastream::v1::ListPrivateConnectionsRequest request);

  virtual google::cloud::Idempotency DeletePrivateConnection(
      google::cloud::datastream::v1::DeletePrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency CreateRoute(
      google::cloud::datastream::v1::CreateRouteRequest const& request);

  virtual google::cloud::Idempotency GetRoute(
      google::cloud::datastream::v1::GetRouteRequest const& request);

  virtual google::cloud::Idempotency ListRoutes(
      google::cloud::datastream::v1::ListRoutesRequest request);

  virtual google::cloud::Idempotency DeleteRoute(
      google::cloud::datastream::v1::DeleteRouteRequest const& request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<DatastreamConnectionIdempotencyPolicy>
MakeDefaultDatastreamConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastream_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTREAM_V1_DATASTREAM_CONNECTION_IDEMPOTENCY_POLICY_H
