// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_INTERNAL_DATASTORE_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_INTERNAL_DATASTORE_METADATA_DECORATOR_H

#include "google/cloud/datastore/v1/internal/datastore_stub.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatastoreMetadata : public DatastoreStub {
 public:
  ~DatastoreMetadata() override = default;
  DatastoreMetadata(std::shared_ptr<DatastoreStub> child,
                    std::multimap<std::string, std::string> fixed_metadata,
                    std::string api_client_header = "");

  StatusOr<google::datastore::v1::LookupResponse> Lookup(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::LookupRequest const& request) override;

  StatusOr<google::datastore::v1::RunQueryResponse> RunQuery(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::RunQueryRequest const& request) override;

  StatusOr<google::datastore::v1::RunAggregationQueryResponse>
  RunAggregationQuery(grpc::ClientContext& context, Options const& options,
                      google::datastore::v1::RunAggregationQueryRequest const&
                          request) override;

  StatusOr<google::datastore::v1::BeginTransactionResponse> BeginTransaction(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::BeginTransactionRequest const& request) override;

  StatusOr<google::datastore::v1::CommitResponse> Commit(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::CommitRequest const& request) override;

  StatusOr<google::datastore::v1::RollbackResponse> Rollback(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::RollbackRequest const& request) override;

  StatusOr<google::datastore::v1::AllocateIdsResponse> AllocateIds(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::AllocateIdsRequest const& request) override;

  StatusOr<google::datastore::v1::ReserveIdsResponse> ReserveIds(
      grpc::ClientContext& context, Options const& options,
      google::datastore::v1::ReserveIdsRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  void SetMetadata(grpc::ClientContext& context, Options const& options,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context, Options const& options);

  std::shared_ptr<DatastoreStub> child_;
  std::multimap<std::string, std::string> fixed_metadata_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_V1_INTERNAL_DATASTORE_METADATA_DECORATOR_H
