// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/internal/datastore_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/absl_str_join_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/routing_matcher.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/datastore/v1/datastore.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatastoreMetadata::DatastoreMetadata(
    std::shared_ptr<DatastoreStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::datastore::v1::LookupResponse> DatastoreMetadata::Lookup(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::LookupRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->Lookup(context, options, request);
}

StatusOr<google::datastore::v1::RunQueryResponse> DatastoreMetadata::RunQuery(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::RunQueryRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->RunQuery(context, options, request);
}

StatusOr<google::datastore::v1::RunAggregationQueryResponse>
DatastoreMetadata::RunAggregationQuery(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::RunAggregationQueryRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->RunAggregationQuery(context, options, request);
}

StatusOr<google::datastore::v1::BeginTransactionResponse>
DatastoreMetadata::BeginTransaction(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::BeginTransactionRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->BeginTransaction(context, options, request);
}

StatusOr<google::datastore::v1::CommitResponse> DatastoreMetadata::Commit(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::CommitRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->Commit(context, options, request);
}

StatusOr<google::datastore::v1::RollbackResponse> DatastoreMetadata::Rollback(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::RollbackRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->Rollback(context, options, request);
}

StatusOr<google::datastore::v1::AllocateIdsResponse>
DatastoreMetadata::AllocateIds(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::AllocateIdsRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->AllocateIds(context, options, request);
}

StatusOr<google::datastore::v1::ReserveIdsResponse>
DatastoreMetadata::ReserveIds(
    grpc::ClientContext& context, Options const& options,
    google::datastore::v1::ReserveIdsRequest const& request) {
  std::vector<std::string> params;
  params.reserve(2);

  if (!request.project_id().empty()) {
    params.push_back(
        absl::StrCat("project_id=", internal::UrlEncode(request.project_id())));
  }

  if (!request.database_id().empty()) {
    params.push_back(absl::StrCat("database_id=",
                                  internal::UrlEncode(request.database_id())));
  }

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->ReserveIds(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
DatastoreMetadata::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> DatastoreMetadata::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetOperation(context, options, request);
}

Status DatastoreMetadata::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteOperation(context, options, request);
}

Status DatastoreMetadata::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CancelOperation(context, options, request);
}

void DatastoreMetadata::SetMetadata(grpc::ClientContext& context,
                                    Options const& options,
                                    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void DatastoreMetadata::SetMetadata(grpc::ClientContext& context,
                                    Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google
