// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/datastore_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace datastore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DatastoreConnectionIdempotencyPolicy::~DatastoreConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<DatastoreConnectionIdempotencyPolicy>
DatastoreConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DatastoreConnectionIdempotencyPolicy>(*this);
}

Idempotency DatastoreConnectionIdempotencyPolicy::Lookup(
    google::datastore::v1::LookupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::RunQuery(
    google::datastore::v1::RunQueryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::RunAggregationQuery(
    google::datastore::v1::RunAggregationQueryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::BeginTransaction(
    google::datastore::v1::BeginTransactionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::Commit(
    google::datastore::v1::CommitRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::Rollback(
    google::datastore::v1::RollbackRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::AllocateIds(
    google::datastore::v1::AllocateIdsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::ReserveIds(
    google::datastore::v1::ReserveIdsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DatastoreConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DatastoreConnectionIdempotencyPolicy>
MakeDefaultDatastoreConnectionIdempotencyPolicy() {
  return std::make_unique<DatastoreConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1
}  // namespace cloud
}  // namespace google
