// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/datastore_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datastore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatastoreClient::DatastoreClient(
    std::shared_ptr<DatastoreConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DatastoreClient::~DatastoreClient() = default;

StatusOr<google::datastore::v1::LookupResponse> DatastoreClient::Lookup(
    std::string const& project_id,
    google::datastore::v1::ReadOptions const& read_options,
    std::vector<google::datastore::v1::Key> const& keys, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::LookupRequest request;
  request.set_project_id(project_id);
  *request.mutable_read_options() = read_options;
  *request.mutable_keys() = {keys.begin(), keys.end()};
  return connection_->Lookup(request);
}

StatusOr<google::datastore::v1::LookupResponse> DatastoreClient::Lookup(
    google::datastore::v1::LookupRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Lookup(request);
}

StatusOr<google::datastore::v1::RunQueryResponse> DatastoreClient::RunQuery(
    google::datastore::v1::RunQueryRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunQuery(request);
}

StatusOr<google::datastore::v1::RunAggregationQueryResponse>
DatastoreClient::RunAggregationQuery(
    google::datastore::v1::RunAggregationQueryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunAggregationQuery(request);
}

StatusOr<google::datastore::v1::BeginTransactionResponse>
DatastoreClient::BeginTransaction(std::string const& project_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::BeginTransactionRequest request;
  request.set_project_id(project_id);
  return connection_->BeginTransaction(request);
}

StatusOr<google::datastore::v1::BeginTransactionResponse>
DatastoreClient::BeginTransaction(
    google::datastore::v1::BeginTransactionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BeginTransaction(request);
}

StatusOr<google::datastore::v1::CommitResponse> DatastoreClient::Commit(
    std::string const& project_id,
    google::datastore::v1::CommitRequest::Mode mode,
    std::string const& transaction,
    std::vector<google::datastore::v1::Mutation> const& mutations,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::CommitRequest request;
  request.set_project_id(project_id);
  request.set_mode(mode);
  request.set_transaction(transaction);
  *request.mutable_mutations() = {mutations.begin(), mutations.end()};
  return connection_->Commit(request);
}

StatusOr<google::datastore::v1::CommitResponse> DatastoreClient::Commit(
    std::string const& project_id,
    google::datastore::v1::CommitRequest::Mode mode,
    std::vector<google::datastore::v1::Mutation> const& mutations,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::CommitRequest request;
  request.set_project_id(project_id);
  request.set_mode(mode);
  *request.mutable_mutations() = {mutations.begin(), mutations.end()};
  return connection_->Commit(request);
}

StatusOr<google::datastore::v1::CommitResponse> DatastoreClient::Commit(
    google::datastore::v1::CommitRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Commit(request);
}

StatusOr<google::datastore::v1::RollbackResponse> DatastoreClient::Rollback(
    std::string const& project_id, std::string const& transaction,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::RollbackRequest request;
  request.set_project_id(project_id);
  request.set_transaction(transaction);
  return connection_->Rollback(request);
}

StatusOr<google::datastore::v1::RollbackResponse> DatastoreClient::Rollback(
    google::datastore::v1::RollbackRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Rollback(request);
}

StatusOr<google::datastore::v1::AllocateIdsResponse>
DatastoreClient::AllocateIds(
    std::string const& project_id,
    std::vector<google::datastore::v1::Key> const& keys, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::AllocateIdsRequest request;
  request.set_project_id(project_id);
  *request.mutable_keys() = {keys.begin(), keys.end()};
  return connection_->AllocateIds(request);
}

StatusOr<google::datastore::v1::AllocateIdsResponse>
DatastoreClient::AllocateIds(
    google::datastore::v1::AllocateIdsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AllocateIds(request);
}

StatusOr<google::datastore::v1::ReserveIdsResponse> DatastoreClient::ReserveIds(
    std::string const& project_id,
    std::vector<google::datastore::v1::Key> const& keys, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::v1::ReserveIdsRequest request;
  request.set_project_id(project_id);
  *request.mutable_keys() = {keys.begin(), keys.end()};
  return connection_->ReserveIds(request);
}

StatusOr<google::datastore::v1::ReserveIdsResponse> DatastoreClient::ReserveIds(
    google::datastore::v1::ReserveIdsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReserveIds(request);
}

StreamRange<google::longrunning::Operation> DatastoreClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> DatastoreClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> DatastoreClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> DatastoreClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status DatastoreClient::DeleteOperation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status DatastoreClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status DatastoreClient::CancelOperation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status DatastoreClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1
}  // namespace cloud
}  // namespace google
