// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/admin/v1/datastore_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_INTERNAL_DATASTORE_ADMIN_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_INTERNAL_DATASTORE_ADMIN_CONNECTION_IMPL_H

#include "google/cloud/datastore/admin/v1/datastore_admin_connection.h"
#include "google/cloud/datastore/admin/v1/datastore_admin_connection_idempotency_policy.h"
#include "google/cloud/datastore/admin/v1/datastore_admin_options.h"
#include "google/cloud/datastore/admin/v1/internal/datastore_admin_retry_traits.h"
#include "google/cloud/datastore/admin/v1/internal/datastore_admin_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datastore_admin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatastoreAdminConnectionImpl
    : public datastore_admin_v1::DatastoreAdminConnection {
 public:
  ~DatastoreAdminConnectionImpl() override = default;

  DatastoreAdminConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<datastore_admin_v1_internal::DatastoreAdminStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
  ExportEntities(google::datastore::admin::v1::ExportEntitiesRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> ExportEntities(
      NoAwaitTag,
      google::datastore::admin::v1::ExportEntitiesRequest const& request)
      override;

  future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
  ExportEntities(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
  ImportEntities(google::datastore::admin::v1::ImportEntitiesRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> ImportEntities(
      NoAwaitTag,
      google::datastore::admin::v1::ImportEntitiesRequest const& request)
      override;

  future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
  ImportEntities(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::datastore::admin::v1::Index>> CreateIndex(
      google::datastore::admin::v1::CreateIndexRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateIndex(
      NoAwaitTag,
      google::datastore::admin::v1::CreateIndexRequest const& request) override;

  future<StatusOr<google::datastore::admin::v1::Index>> CreateIndex(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::datastore::admin::v1::Index>> DeleteIndex(
      google::datastore::admin::v1::DeleteIndexRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteIndex(
      NoAwaitTag,
      google::datastore::admin::v1::DeleteIndexRequest const& request) override;

  future<StatusOr<google::datastore::admin::v1::Index>> DeleteIndex(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::datastore::admin::v1::Index> GetIndex(
      google::datastore::admin::v1::GetIndexRequest const& request) override;

  StreamRange<google::datastore::admin::v1::Index> ListIndexes(
      google::datastore::admin::v1::ListIndexesRequest request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<datastore_admin_v1_internal::DatastoreAdminStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_admin_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTORE_ADMIN_V1_INTERNAL_DATASTORE_ADMIN_CONNECTION_IMPL_H
