// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#include "google/cloud/dataproc/v1/session_template_controller_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SessionTemplateControllerConnectionIdempotencyPolicy::
    ~SessionTemplateControllerConnectionIdempotencyPolicy() = default;

std::unique_ptr<SessionTemplateControllerConnectionIdempotencyPolicy>
SessionTemplateControllerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SessionTemplateControllerConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::CreateSessionTemplate(
    google::cloud::dataproc::v1::CreateSessionTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::UpdateSessionTemplate(
    google::cloud::dataproc::v1::UpdateSessionTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::GetSessionTemplate(
    google::cloud::dataproc::v1::GetSessionTemplateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::ListSessionTemplates(
    google::cloud::dataproc::v1::ListSessionTemplatesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::DeleteSessionTemplate(
    google::cloud::dataproc::v1::DeleteSessionTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SessionTemplateControllerConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency SessionTemplateControllerConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SessionTemplateControllerConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SessionTemplateControllerConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SessionTemplateControllerConnectionIdempotencyPolicy>
MakeDefaultSessionTemplateControllerConnectionIdempotencyPolicy() {
  return std::make_unique<
      SessionTemplateControllerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
