// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/sessions.proto

#include "google/cloud/dataproc/v1/session_controller_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SessionControllerConnectionIdempotencyPolicy::
    ~SessionControllerConnectionIdempotencyPolicy() = default;

std::unique_ptr<SessionControllerConnectionIdempotencyPolicy>
SessionControllerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SessionControllerConnectionIdempotencyPolicy>(*this);
}

Idempotency SessionControllerConnectionIdempotencyPolicy::CreateSession(
    google::cloud::dataproc::v1::CreateSessionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::GetSession(
    google::cloud::dataproc::v1::GetSessionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::ListSessions(
    google::cloud::dataproc::v1::ListSessionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::TerminateSession(
    google::cloud::dataproc::v1::TerminateSessionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::DeleteSession(
    google::cloud::dataproc::v1::DeleteSessionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SessionControllerConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SessionControllerConnectionIdempotencyPolicy>
MakeDefaultSessionControllerConnectionIdempotencyPolicy() {
  return std::make_unique<SessionControllerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
