// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/node_groups.proto

#include "google/cloud/dataproc/v1/node_group_controller_connection.h"
#include "google/cloud/dataproc/v1/internal/node_group_controller_connection_impl.h"
#include "google/cloud/dataproc/v1/internal/node_group_controller_option_defaults.h"
#include "google/cloud/dataproc/v1/internal/node_group_controller_stub_factory.h"
#include "google/cloud/dataproc/v1/internal/node_group_controller_tracing_connection.h"
#include "google/cloud/dataproc/v1/node_group_controller_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NodeGroupControllerConnection::~NodeGroupControllerConnection() = default;

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerConnection::CreateNodeGroup(
    google::cloud::dataproc::v1::CreateNodeGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::NodeGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerConnection::CreateNodeGroup(
    NoAwaitTag, google::cloud::dataproc::v1::CreateNodeGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerConnection::CreateNodeGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::NodeGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerConnection::ResizeNodeGroup(
    google::cloud::dataproc::v1::ResizeNodeGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::NodeGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerConnection::ResizeNodeGroup(
    NoAwaitTag, google::cloud::dataproc::v1::ResizeNodeGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerConnection::ResizeNodeGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::NodeGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::dataproc::v1::NodeGroup>
NodeGroupControllerConnection::GetNodeGroup(
    google::cloud::dataproc::v1::GetNodeGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> NodeGroupControllerConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> NodeGroupControllerConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NodeGroupControllerConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
NodeGroupControllerConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status NodeGroupControllerConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status NodeGroupControllerConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<NodeGroupControllerConnection>
MakeNodeGroupControllerConnection(std::string const& location,
                                  Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 NodeGroupControllerPolicyOptionList>(options,
                                                                      __func__);
  options = dataproc_v1_internal::NodeGroupControllerDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dataproc_v1_internal::CreateDefaultNodeGroupControllerStub(
      std::move(auth), options);
  return dataproc_v1_internal::MakeNodeGroupControllerTracingConnection(
      std::make_shared<dataproc_v1_internal::NodeGroupControllerConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
