// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/node_groups.proto

#include "google/cloud/dataproc/v1/node_group_controller_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NodeGroupControllerClient::NodeGroupControllerClient(
    std::shared_ptr<NodeGroupControllerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NodeGroupControllerClient::~NodeGroupControllerClient() = default;

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerClient::CreateNodeGroup(
    std::string const& parent,
    google::cloud::dataproc::v1::NodeGroup const& node_group,
    std::string const& node_group_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::CreateNodeGroupRequest request;
  request.set_parent(parent);
  *request.mutable_node_group() = node_group;
  request.set_node_group_id(node_group_id);
  return connection_->CreateNodeGroup(request);
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerClient::CreateNodeGroup(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataproc::v1::NodeGroup const& node_group,
    std::string const& node_group_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::CreateNodeGroupRequest request;
  request.set_parent(parent);
  *request.mutable_node_group() = node_group;
  request.set_node_group_id(node_group_id);
  return connection_->CreateNodeGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerClient::CreateNodeGroup(
    google::cloud::dataproc::v1::CreateNodeGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodeGroup(request);
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerClient::CreateNodeGroup(
    NoAwaitTag,
    google::cloud::dataproc::v1::CreateNodeGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodeGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerClient::CreateNodeGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodeGroup(operation);
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerClient::ResizeNodeGroup(std::string const& name,
                                           std::int32_t size, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::ResizeNodeGroupRequest request;
  request.set_name(name);
  request.set_size(size);
  return connection_->ResizeNodeGroup(request);
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerClient::ResizeNodeGroup(NoAwaitTag, std::string const& name,
                                           std::int32_t size, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::ResizeNodeGroupRequest request;
  request.set_name(name);
  request.set_size(size);
  return connection_->ResizeNodeGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerClient::ResizeNodeGroup(
    google::cloud::dataproc::v1::ResizeNodeGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResizeNodeGroup(request);
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerClient::ResizeNodeGroup(
    NoAwaitTag,
    google::cloud::dataproc::v1::ResizeNodeGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResizeNodeGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerClient::ResizeNodeGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResizeNodeGroup(operation);
}

StatusOr<google::cloud::dataproc::v1::NodeGroup>
NodeGroupControllerClient::GetNodeGroup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::GetNodeGroupRequest request;
  request.set_name(name);
  return connection_->GetNodeGroup(request);
}

StatusOr<google::cloud::dataproc::v1::NodeGroup>
NodeGroupControllerClient::GetNodeGroup(
    google::cloud::dataproc::v1::GetNodeGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNodeGroup(request);
}

StatusOr<google::iam::v1::Policy> NodeGroupControllerClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> NodeGroupControllerClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NodeGroupControllerClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
NodeGroupControllerClient::ListOperations(std::string const& name,
                                          std::string const& filter,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
NodeGroupControllerClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerClient::GetOperation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
NodeGroupControllerClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status NodeGroupControllerClient::DeleteOperation(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status NodeGroupControllerClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status NodeGroupControllerClient::CancelOperation(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status NodeGroupControllerClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
