// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#include "google/cloud/dataproc/v1/internal/session_template_controller_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SessionTemplateControllerTracingConnection::
    SessionTemplateControllerTracingConnection(
        std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingConnection::CreateSessionTemplate(
    google::cloud::dataproc::v1::CreateSessionTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::"
      "CreateSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSessionTemplate(request));
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingConnection::UpdateSessionTemplate(
    google::cloud::dataproc::v1::UpdateSessionTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::"
      "UpdateSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSessionTemplate(request));
}

StatusOr<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingConnection::GetSessionTemplate(
    google::cloud::dataproc::v1::GetSessionTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::GetSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSessionTemplate(request));
}

StreamRange<google::cloud::dataproc::v1::SessionTemplate>
SessionTemplateControllerTracingConnection::ListSessionTemplates(
    google::cloud::dataproc::v1::ListSessionTemplatesRequest request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::ListSessionTemplates");
  internal::OTelScope scope(span);
  auto sr = child_->ListSessionTemplates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataproc::v1::SessionTemplate>(std::move(span),
                                                    std::move(sr));
}

Status SessionTemplateControllerTracingConnection::DeleteSessionTemplate(
    google::cloud::dataproc::v1::DeleteSessionTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::"
      "DeleteSessionTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSessionTemplate(request));
}

StatusOr<google::iam::v1::Policy>
SessionTemplateControllerTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
SessionTemplateControllerTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SessionTemplateControllerTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
SessionTemplateControllerTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
SessionTemplateControllerTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status SessionTemplateControllerTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status SessionTemplateControllerTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::SessionTemplateControllerConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection>
MakeSessionTemplateControllerTracingConnection(
    std::shared_ptr<dataproc_v1::SessionTemplateControllerConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SessionTemplateControllerTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
