// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/clusters.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_CLUSTER_CONTROLLER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_CLUSTER_CONTROLLER_TRACING_CONNECTION_H

#include "google/cloud/dataproc/v1/cluster_controller_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ClusterControllerTracingConnection
    : public dataproc_v1::ClusterControllerConnection {
 public:
  ~ClusterControllerTracingConnection() override = default;

  explicit ClusterControllerTracingConnection(
      std::shared_ptr<dataproc_v1::ClusterControllerConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> CreateCluster(
      google::cloud::dataproc::v1::CreateClusterRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateCluster(
      NoAwaitTag,
      google::cloud::dataproc::v1::CreateClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> CreateCluster(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> UpdateCluster(
      google::cloud::dataproc::v1::UpdateClusterRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateCluster(
      NoAwaitTag,
      google::cloud::dataproc::v1::UpdateClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> UpdateCluster(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> StopCluster(
      google::cloud::dataproc::v1::StopClusterRequest const& request) override;

  StatusOr<google::longrunning::Operation> StopCluster(
      NoAwaitTag,
      google::cloud::dataproc::v1::StopClusterRequest const& request) override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> StopCluster(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> StartCluster(
      google::cloud::dataproc::v1::StartClusterRequest const& request) override;

  StatusOr<google::longrunning::Operation> StartCluster(
      NoAwaitTag,
      google::cloud::dataproc::v1::StartClusterRequest const& request) override;

  future<StatusOr<google::cloud::dataproc::v1::Cluster>> StartCluster(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataproc::v1::ClusterOperationMetadata>>
  DeleteCluster(google::cloud::dataproc::v1::DeleteClusterRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteCluster(
      NoAwaitTag,
      google::cloud::dataproc::v1::DeleteClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::ClusterOperationMetadata>>
  DeleteCluster(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::dataproc::v1::Cluster> GetCluster(
      google::cloud::dataproc::v1::GetClusterRequest const& request) override;

  StreamRange<google::cloud::dataproc::v1::Cluster> ListClusters(
      google::cloud::dataproc::v1::ListClustersRequest request) override;

  future<StatusOr<google::cloud::dataproc::v1::DiagnoseClusterResults>>
  DiagnoseCluster(google::cloud::dataproc::v1::DiagnoseClusterRequest const&
                      request) override;

  StatusOr<google::longrunning::Operation> DiagnoseCluster(
      NoAwaitTag,
      google::cloud::dataproc::v1::DiagnoseClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::DiagnoseClusterResults>>
  DiagnoseCluster(google::longrunning::Operation const& operation) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<dataproc_v1::ClusterControllerConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dataproc_v1::ClusterControllerConnection>
MakeClusterControllerTracingConnection(
    std::shared_ptr<dataproc_v1::ClusterControllerConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_CLUSTER_CONTROLLER_TRACING_CONNECTION_H
