// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

#include "google/cloud/dataproc/v1/internal/autoscaling_policy_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataproc/v1/autoscaling_policies.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutoscalingPolicyServiceMetadata::AutoscalingPolicyServiceMetadata(
    std::shared_ptr<AutoscalingPolicyServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceMetadata::CreateAutoscalingPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::CreateAutoscalingPolicyRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateAutoscalingPolicy(context, options, request);
}

StatusOr<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceMetadata::UpdateAutoscalingPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::UpdateAutoscalingPolicyRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("policy.name=",
                           internal::UrlEncode(request.policy().name())));
  return child_->UpdateAutoscalingPolicy(context, options, request);
}

StatusOr<google::cloud::dataproc::v1::AutoscalingPolicy>
AutoscalingPolicyServiceMetadata::GetAutoscalingPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::GetAutoscalingPolicyRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetAutoscalingPolicy(context, options, request);
}

StatusOr<google::cloud::dataproc::v1::ListAutoscalingPoliciesResponse>
AutoscalingPolicyServiceMetadata::ListAutoscalingPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::ListAutoscalingPoliciesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListAutoscalingPolicies(context, options, request);
}

Status AutoscalingPolicyServiceMetadata::DeleteAutoscalingPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataproc::v1::DeleteAutoscalingPolicyRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteAutoscalingPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy>
AutoscalingPolicyServiceMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy>
AutoscalingPolicyServiceMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
AutoscalingPolicyServiceMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
AutoscalingPolicyServiceMetadata::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation>
AutoscalingPolicyServiceMetadata::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetOperation(context, options, request);
}

Status AutoscalingPolicyServiceMetadata::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteOperation(context, options, request);
}

Status AutoscalingPolicyServiceMetadata::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CancelOperation(context, options, request);
}

void AutoscalingPolicyServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void AutoscalingPolicyServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                                   Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
