// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

#include "google/cloud/dataproc/v1/autoscaling_policy_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AutoscalingPolicyServiceConnectionIdempotencyPolicy::
    ~AutoscalingPolicyServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<AutoscalingPolicyServiceConnectionIdempotencyPolicy>
AutoscalingPolicyServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AutoscalingPolicyServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::CreateAutoscalingPolicy(
    google::cloud::dataproc::v1::CreateAutoscalingPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::UpdateAutoscalingPolicy(
    google::cloud::dataproc::v1::UpdateAutoscalingPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::GetAutoscalingPolicy(
    google::cloud::dataproc::v1::GetAutoscalingPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::ListAutoscalingPolicies(
    google::cloud::dataproc::v1::ListAutoscalingPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::DeleteAutoscalingPolicy(
    google::cloud::dataproc::v1::DeleteAutoscalingPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoscalingPolicyServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency AutoscalingPolicyServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutoscalingPolicyServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AutoscalingPolicyServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AutoscalingPolicyServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AutoscalingPolicyServiceConnectionIdempotencyPolicy>
MakeDefaultAutoscalingPolicyServiceConnectionIdempotencyPolicy() {
  return std::make_unique<
      AutoscalingPolicyServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
