// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/metadata.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_METADATA_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_METADATA_TRACING_CONNECTION_H

#include "google/cloud/dataplex/v1/metadata_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class MetadataServiceTracingConnection
    : public dataplex_v1::MetadataServiceConnection {
 public:
  ~MetadataServiceTracingConnection() override = default;

  explicit MetadataServiceTracingConnection(
      std::shared_ptr<dataplex_v1::MetadataServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::dataplex::v1::Entity> CreateEntity(
      google::cloud::dataplex::v1::CreateEntityRequest const& request) override;

  StatusOr<google::cloud::dataplex::v1::Entity> UpdateEntity(
      google::cloud::dataplex::v1::UpdateEntityRequest const& request) override;

  Status DeleteEntity(
      google::cloud::dataplex::v1::DeleteEntityRequest const& request) override;

  StatusOr<google::cloud::dataplex::v1::Entity> GetEntity(
      google::cloud::dataplex::v1::GetEntityRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Entity> ListEntities(
      google::cloud::dataplex::v1::ListEntitiesRequest request) override;

  StatusOr<google::cloud::dataplex::v1::Partition> CreatePartition(
      google::cloud::dataplex::v1::CreatePartitionRequest const& request)
      override;

  Status DeletePartition(
      google::cloud::dataplex::v1::DeletePartitionRequest const& request)
      override;

  StatusOr<google::cloud::dataplex::v1::Partition> GetPartition(
      google::cloud::dataplex::v1::GetPartitionRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Partition> ListPartitions(
      google::cloud::dataplex::v1::ListPartitionsRequest request) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<dataplex_v1::MetadataServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dataplex_v1::MetadataServiceConnection>
MakeMetadataServiceTracingConnection(
    std::shared_ptr<dataplex_v1::MetadataServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_METADATA_TRACING_CONNECTION_H
