// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/data_taxonomy.proto

#include "google/cloud/dataplex/v1/data_taxonomy_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataTaxonomyServiceClient::DataTaxonomyServiceClient(
    std::shared_ptr<DataTaxonomyServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DataTaxonomyServiceClient::~DataTaxonomyServiceClient() = default;

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceClient::CreateDataTaxonomy(
    std::string const& parent,
    google::cloud::dataplex::v1::DataTaxonomy const& data_taxonomy,
    std::string const& data_taxonomy_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataTaxonomyRequest request;
  request.set_parent(parent);
  *request.mutable_data_taxonomy() = data_taxonomy;
  request.set_data_taxonomy_id(data_taxonomy_id);
  return connection_->CreateDataTaxonomy(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::CreateDataTaxonomy(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataplex::v1::DataTaxonomy const& data_taxonomy,
    std::string const& data_taxonomy_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataTaxonomyRequest request;
  request.set_parent(parent);
  *request.mutable_data_taxonomy() = data_taxonomy;
  request.set_data_taxonomy_id(data_taxonomy_id);
  return connection_->CreateDataTaxonomy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceClient::CreateDataTaxonomy(
    google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataTaxonomy(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::CreateDataTaxonomy(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataTaxonomy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceClient::CreateDataTaxonomy(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataTaxonomy(operation);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceClient::UpdateDataTaxonomy(
    google::cloud::dataplex::v1::DataTaxonomy const& data_taxonomy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataTaxonomyRequest request;
  *request.mutable_data_taxonomy() = data_taxonomy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataTaxonomy(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::UpdateDataTaxonomy(
    NoAwaitTag, google::cloud::dataplex::v1::DataTaxonomy const& data_taxonomy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataTaxonomyRequest request;
  *request.mutable_data_taxonomy() = data_taxonomy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataTaxonomy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceClient::UpdateDataTaxonomy(
    google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataTaxonomy(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::UpdateDataTaxonomy(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataTaxonomy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceClient::UpdateDataTaxonomy(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataTaxonomy(operation);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataTaxonomy(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataTaxonomyRequest request;
  request.set_name(name);
  return connection_->DeleteDataTaxonomy(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::DeleteDataTaxonomy(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataTaxonomyRequest request;
  request.set_name(name);
  return connection_->DeleteDataTaxonomy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataTaxonomy(
    google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataTaxonomy(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::DeleteDataTaxonomy(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataTaxonomy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataTaxonomy(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataTaxonomy(operation);
}

StreamRange<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceClient::ListDataTaxonomies(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListDataTaxonomiesRequest request;
  request.set_parent(parent);
  return connection_->ListDataTaxonomies(request);
}

StreamRange<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceClient::ListDataTaxonomies(
    google::cloud::dataplex::v1::ListDataTaxonomiesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataTaxonomies(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceClient::GetDataTaxonomy(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetDataTaxonomyRequest request;
  request.set_name(name);
  return connection_->GetDataTaxonomy(request);
}

StatusOr<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceClient::GetDataTaxonomy(
    google::cloud::dataplex::v1::GetDataTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataTaxonomy(request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceClient::CreateDataAttributeBinding(
    std::string const& parent,
    google::cloud::dataplex::v1::DataAttributeBinding const&
        data_attribute_binding,
    std::string const& data_attribute_binding_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataAttributeBindingRequest request;
  request.set_parent(parent);
  *request.mutable_data_attribute_binding() = data_attribute_binding;
  request.set_data_attribute_binding_id(data_attribute_binding_id);
  return connection_->CreateDataAttributeBinding(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::CreateDataAttributeBinding(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataplex::v1::DataAttributeBinding const&
        data_attribute_binding,
    std::string const& data_attribute_binding_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataAttributeBindingRequest request;
  request.set_parent(parent);
  *request.mutable_data_attribute_binding() = data_attribute_binding;
  request.set_data_attribute_binding_id(data_attribute_binding_id);
  return connection_->CreateDataAttributeBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceClient::CreateDataAttributeBinding(
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataAttributeBinding(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::CreateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataAttributeBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceClient::CreateDataAttributeBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataAttributeBinding(operation);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceClient::UpdateDataAttributeBinding(
    google::cloud::dataplex::v1::DataAttributeBinding const&
        data_attribute_binding,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest request;
  *request.mutable_data_attribute_binding() = data_attribute_binding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataAttributeBinding(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::UpdateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::DataAttributeBinding const&
        data_attribute_binding,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest request;
  *request.mutable_data_attribute_binding() = data_attribute_binding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataAttributeBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceClient::UpdateDataAttributeBinding(
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataAttributeBinding(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::UpdateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataAttributeBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceClient::UpdateDataAttributeBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataAttributeBinding(operation);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataAttributeBinding(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest request;
  request.set_name(name);
  return connection_->DeleteDataAttributeBinding(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::DeleteDataAttributeBinding(NoAwaitTag,
                                                      std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest request;
  request.set_name(name);
  return connection_->DeleteDataAttributeBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataAttributeBinding(
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataAttributeBinding(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::DeleteDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataAttributeBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataAttributeBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataAttributeBinding(operation);
}

StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceClient::ListDataAttributeBindings(std::string const& parent,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListDataAttributeBindingsRequest request;
  request.set_parent(parent);
  return connection_->ListDataAttributeBindings(request);
}

StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceClient::ListDataAttributeBindings(
    google::cloud::dataplex::v1::ListDataAttributeBindingsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataAttributeBindings(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceClient::GetDataAttributeBinding(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetDataAttributeBindingRequest request;
  request.set_name(name);
  return connection_->GetDataAttributeBinding(request);
}

StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceClient::GetDataAttributeBinding(
    google::cloud::dataplex::v1::GetDataAttributeBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataAttributeBinding(request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceClient::CreateDataAttribute(
    std::string const& parent,
    google::cloud::dataplex::v1::DataAttribute const& data_attribute,
    std::string const& data_attribute_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataAttributeRequest request;
  request.set_parent(parent);
  *request.mutable_data_attribute() = data_attribute;
  request.set_data_attribute_id(data_attribute_id);
  return connection_->CreateDataAttribute(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::CreateDataAttribute(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataplex::v1::DataAttribute const& data_attribute,
    std::string const& data_attribute_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataAttributeRequest request;
  request.set_parent(parent);
  *request.mutable_data_attribute() = data_attribute;
  request.set_data_attribute_id(data_attribute_id);
  return connection_->CreateDataAttribute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceClient::CreateDataAttribute(
    google::cloud::dataplex::v1::CreateDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataAttribute(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::CreateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataAttribute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceClient::CreateDataAttribute(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataAttribute(operation);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceClient::UpdateDataAttribute(
    google::cloud::dataplex::v1::DataAttribute const& data_attribute,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataAttributeRequest request;
  *request.mutable_data_attribute() = data_attribute;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataAttribute(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::UpdateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::DataAttribute const& data_attribute,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataAttributeRequest request;
  *request.mutable_data_attribute() = data_attribute;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataAttribute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceClient::UpdateDataAttribute(
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataAttribute(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::UpdateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataAttribute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceClient::UpdateDataAttribute(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataAttribute(operation);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataAttribute(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataAttributeRequest request;
  request.set_name(name);
  return connection_->DeleteDataAttribute(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::DeleteDataAttribute(NoAwaitTag,
                                               std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataAttributeRequest request;
  request.set_name(name);
  return connection_->DeleteDataAttribute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataAttribute(
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataAttribute(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::DeleteDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataAttribute(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceClient::DeleteDataAttribute(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataAttribute(operation);
}

StreamRange<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceClient::ListDataAttributes(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListDataAttributesRequest request;
  request.set_parent(parent);
  return connection_->ListDataAttributes(request);
}

StreamRange<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceClient::ListDataAttributes(
    google::cloud::dataplex::v1::ListDataAttributesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataAttributes(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceClient::GetDataAttribute(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetDataAttributeRequest request;
  request.set_name(name);
  return connection_->GetDataAttribute(request);
}

StatusOr<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceClient::GetDataAttribute(
    google::cloud::dataplex::v1::GetDataAttributeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataAttribute(request);
}

StreamRange<google::cloud::location::Location>
DataTaxonomyServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
DataTaxonomyServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> DataTaxonomyServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DataTaxonomyServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataTaxonomyServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
DataTaxonomyServiceClient::ListOperations(std::string const& name,
                                          std::string const& filter,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
DataTaxonomyServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::GetOperation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status DataTaxonomyServiceClient::DeleteOperation(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status DataTaxonomyServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status DataTaxonomyServiceClient::CancelOperation(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status DataTaxonomyServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
