// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_SCAN_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_SCAN_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/dataplex/v1/datascans.grpc.pb.h>
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/iam/v1/iam_policy.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataScanServiceConnectionIdempotencyPolicy {
 public:
  virtual ~DataScanServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DataScanServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateDataScan(
      google::cloud::dataplex::v1::CreateDataScanRequest const& request);

  virtual google::cloud::Idempotency UpdateDataScan(
      google::cloud::dataplex::v1::UpdateDataScanRequest const& request);

  virtual google::cloud::Idempotency DeleteDataScan(
      google::cloud::dataplex::v1::DeleteDataScanRequest const& request);

  virtual google::cloud::Idempotency GetDataScan(
      google::cloud::dataplex::v1::GetDataScanRequest const& request);

  virtual google::cloud::Idempotency ListDataScans(
      google::cloud::dataplex::v1::ListDataScansRequest request);

  virtual google::cloud::Idempotency RunDataScan(
      google::cloud::dataplex::v1::RunDataScanRequest const& request);

  virtual google::cloud::Idempotency GetDataScanJob(
      google::cloud::dataplex::v1::GetDataScanJobRequest const& request);

  virtual google::cloud::Idempotency ListDataScanJobs(
      google::cloud::dataplex::v1::ListDataScanJobsRequest request);

  virtual google::cloud::Idempotency GenerateDataQualityRules(
      google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&
          request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<DataScanServiceConnectionIdempotencyPolicy>
MakeDefaultDataScanServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_SCAN_CONNECTION_IDEMPOTENCY_POLICY_H
