// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#include "google/cloud/dataplex/v1/data_scan_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DataScanServiceConnectionIdempotencyPolicy::
    ~DataScanServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DataScanServiceConnectionIdempotencyPolicy>
DataScanServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DataScanServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::CreateDataScan(
    google::cloud::dataplex::v1::CreateDataScanRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::UpdateDataScan(
    google::cloud::dataplex::v1::UpdateDataScanRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::DeleteDataScan(
    google::cloud::dataplex::v1::DeleteDataScanRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::GetDataScan(
    google::cloud::dataplex::v1::GetDataScanRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::ListDataScans(
    google::cloud::dataplex::v1::ListDataScansRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::RunDataScan(
    google::cloud::dataplex::v1::RunDataScanRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::GetDataScanJob(
    google::cloud::dataplex::v1::GetDataScanJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::ListDataScanJobs(
    google::cloud::dataplex::v1::ListDataScanJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
DataScanServiceConnectionIdempotencyPolicy::GenerateDataQualityRules(
    google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataScanServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DataScanServiceConnectionIdempotencyPolicy>
MakeDefaultDataScanServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DataScanServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
