// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#include "google/cloud/dataplex/v1/data_scan_connection.h"
#include "google/cloud/dataplex/v1/data_scan_options.h"
#include "google/cloud/dataplex/v1/internal/data_scan_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/data_scan_option_defaults.h"
#include "google/cloud/dataplex/v1/internal/data_scan_stub_factory.h"
#include "google/cloud/dataplex/v1/internal/data_scan_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataScanServiceConnection::~DataScanServiceConnection() = default;

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnection::CreateDataScan(
    google::cloud::dataplex::v1::CreateDataScanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataScan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnection::CreateDataScan(
    NoAwaitTag, google::cloud::dataplex::v1::CreateDataScanRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnection::CreateDataScan(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataScan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnection::UpdateDataScan(
    google::cloud::dataplex::v1::UpdateDataScanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataScan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnection::UpdateDataScan(
    NoAwaitTag, google::cloud::dataplex::v1::UpdateDataScanRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnection::UpdateDataScan(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataScan>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceConnection::DeleteDataScan(
    google::cloud::dataplex::v1::DeleteDataScanRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnection::DeleteDataScan(
    NoAwaitTag, google::cloud::dataplex::v1::DeleteDataScanRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceConnection::DeleteDataScan(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::dataplex::v1::DataScan>
DataScanServiceConnection::GetDataScan(
    google::cloud::dataplex::v1::GetDataScanRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataplex::v1::DataScan>
DataScanServiceConnection::ListDataScans(
    google::cloud::dataplex::v1::
        ListDataScansRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataScan>>();
}

StatusOr<google::cloud::dataplex::v1::RunDataScanResponse>
DataScanServiceConnection::RunDataScan(
    google::cloud::dataplex::v1::RunDataScanRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceConnection::GetDataScanJob(
    google::cloud::dataplex::v1::GetDataScanJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceConnection::ListDataScanJobs(
    google::cloud::dataplex::v1::
        ListDataScanJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataScanJob>>();
}

StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
DataScanServiceConnection::GenerateDataQualityRules(
    google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::location::Location>
DataScanServiceConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
DataScanServiceConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DataScanServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DataScanServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataScanServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
DataScanServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataScanServiceConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataScanServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DataScanServiceConnection> MakeDataScanServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DataScanServicePolicyOptionList>(options,
                                                                  __func__);
  options =
      dataplex_v1_internal::DataScanServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dataplex_v1_internal::CreateDefaultDataScanServiceStub(
      std::move(auth), options);
  return dataplex_v1_internal::MakeDataScanServiceTracingConnection(
      std::make_shared<dataplex_v1_internal::DataScanServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
