// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#include "google/cloud/dataplex/v1/data_scan_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataScanServiceClient::DataScanServiceClient(
    std::shared_ptr<DataScanServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DataScanServiceClient::~DataScanServiceClient() = default;

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceClient::CreateDataScan(
    std::string const& parent,
    google::cloud::dataplex::v1::DataScan const& data_scan,
    std::string const& data_scan_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataScanRequest request;
  request.set_parent(parent);
  *request.mutable_data_scan() = data_scan;
  request.set_data_scan_id(data_scan_id);
  return connection_->CreateDataScan(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::CreateDataScan(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataplex::v1::DataScan const& data_scan,
    std::string const& data_scan_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateDataScanRequest request;
  request.set_parent(parent);
  *request.mutable_data_scan() = data_scan;
  request.set_data_scan_id(data_scan_id);
  return connection_->CreateDataScan(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceClient::CreateDataScan(
    google::cloud::dataplex::v1::CreateDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataScan(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::CreateDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataScan(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceClient::CreateDataScan(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataScan(operation);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceClient::UpdateDataScan(
    google::cloud::dataplex::v1::DataScan const& data_scan,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataScanRequest request;
  *request.mutable_data_scan() = data_scan;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataScan(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::UpdateDataScan(
    NoAwaitTag, google::cloud::dataplex::v1::DataScan const& data_scan,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::UpdateDataScanRequest request;
  *request.mutable_data_scan() = data_scan;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataScan(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceClient::UpdateDataScan(
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataScan(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::UpdateDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataScan(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceClient::UpdateDataScan(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataScan(operation);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceClient::DeleteDataScan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataScanRequest request;
  request.set_name(name);
  return connection_->DeleteDataScan(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::DeleteDataScan(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteDataScanRequest request;
  request.set_name(name);
  return connection_->DeleteDataScan(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceClient::DeleteDataScan(
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataScan(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::DeleteDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataScan(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceClient::DeleteDataScan(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataScan(operation);
}

StatusOr<google::cloud::dataplex::v1::DataScan>
DataScanServiceClient::GetDataScan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetDataScanRequest request;
  request.set_name(name);
  return connection_->GetDataScan(request);
}

StatusOr<google::cloud::dataplex::v1::DataScan>
DataScanServiceClient::GetDataScan(
    google::cloud::dataplex::v1::GetDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataScan(request);
}

StreamRange<google::cloud::dataplex::v1::DataScan>
DataScanServiceClient::ListDataScans(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListDataScansRequest request;
  request.set_parent(parent);
  return connection_->ListDataScans(request);
}

StreamRange<google::cloud::dataplex::v1::DataScan>
DataScanServiceClient::ListDataScans(
    google::cloud::dataplex::v1::ListDataScansRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataScans(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::RunDataScanResponse>
DataScanServiceClient::RunDataScan(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::RunDataScanRequest request;
  request.set_name(name);
  return connection_->RunDataScan(request);
}

StatusOr<google::cloud::dataplex::v1::RunDataScanResponse>
DataScanServiceClient::RunDataScan(
    google::cloud::dataplex::v1::RunDataScanRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunDataScan(request);
}

StatusOr<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceClient::GetDataScanJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetDataScanJobRequest request;
  request.set_name(name);
  return connection_->GetDataScanJob(request);
}

StatusOr<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceClient::GetDataScanJob(
    google::cloud::dataplex::v1::GetDataScanJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataScanJob(request);
}

StreamRange<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceClient::ListDataScanJobs(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListDataScanJobsRequest request;
  request.set_parent(parent);
  return connection_->ListDataScanJobs(request);
}

StreamRange<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceClient::ListDataScanJobs(
    google::cloud::dataplex::v1::ListDataScanJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataScanJobs(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
DataScanServiceClient::GenerateDataQualityRules(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GenerateDataQualityRulesRequest request;
  request.set_name(name);
  return connection_->GenerateDataQualityRules(request);
}

StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
DataScanServiceClient::GenerateDataQualityRules(
    google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateDataQualityRules(request);
}

StreamRange<google::cloud::location::Location>
DataScanServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> DataScanServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> DataScanServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DataScanServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataScanServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
DataScanServiceClient::ListOperations(std::string const& name,
                                      std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
DataScanServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> DataScanServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status DataScanServiceClient::DeleteOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status DataScanServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status DataScanServiceClient::CancelOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status DataScanServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
