// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/content.proto

#include "google/cloud/dataplex/v1/content_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ContentServiceConnectionIdempotencyPolicy::
    ~ContentServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ContentServiceConnectionIdempotencyPolicy>
ContentServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ContentServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency ContentServiceConnectionIdempotencyPolicy::CreateContent(
    google::cloud::dataplex::v1::CreateContentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::UpdateContent(
    google::cloud::dataplex::v1::UpdateContentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::DeleteContent(
    google::cloud::dataplex::v1::DeleteContentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::GetContent(
    google::cloud::dataplex::v1::GetContentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::ListContent(
    google::cloud::dataplex::v1::ListContentRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ContentServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ContentServiceConnectionIdempotencyPolicy>
MakeDefaultContentServiceConnectionIdempotencyPolicy() {
  return std::make_unique<ContentServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
