// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/clouddms/v1/clouddms.proto

#include "google/cloud/datamigration/v1/internal/data_migration_auth_decorator.h"
#include <google/cloud/clouddms/v1/clouddms.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datamigration_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataMigrationServiceAuth::DataMigrationServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DataMigrationServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::clouddms::v1::ListMigrationJobsResponse>
DataMigrationServiceAuth::ListMigrationJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::ListMigrationJobsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListMigrationJobs(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::MigrationJob>
DataMigrationServiceAuth::GetMigrationJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GetMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncCreateMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::CreateMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateMigrationJob(cq, *std::move(context),
                                              std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::CreateMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::CreateMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncUpdateMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::UpdateMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateMigrationJob(cq, *std::move(context),
                                              std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::UpdateMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::UpdateMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncDeleteMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::DeleteMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteMigrationJob(cq, *std::move(context),
                                              std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::DeleteMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::DeleteMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncStartMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::StartMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncStartMigrationJob(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::StartMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::StartMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->StartMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncStopMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::StopMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncStopMigrationJob(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::StopMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::StopMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->StopMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncResumeMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::ResumeMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncResumeMigrationJob(cq, *std::move(context),
                                              std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::ResumeMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::ResumeMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ResumeMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncPromoteMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::PromoteMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncPromoteMigrationJob(cq, *std::move(context),
                                               std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::PromoteMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::PromoteMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PromoteMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncVerifyMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::VerifyMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncVerifyMigrationJob(cq, *std::move(context),
                                              std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::VerifyMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::VerifyMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->VerifyMigrationJob(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncRestartMigrationJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::RestartMigrationJobRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncRestartMigrationJob(cq, *std::move(context),
                                               std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::RestartMigrationJob(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::RestartMigrationJobRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RestartMigrationJob(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::SshScript>
DataMigrationServiceAuth::GenerateSshScript(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GenerateSshScriptRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GenerateSshScript(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::TcpProxyScript>
DataMigrationServiceAuth::GenerateTcpProxyScript(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GenerateTcpProxyScriptRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GenerateTcpProxyScript(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::ListConnectionProfilesResponse>
DataMigrationServiceAuth::ListConnectionProfiles(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::ListConnectionProfilesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListConnectionProfiles(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::ConnectionProfile>
DataMigrationServiceAuth::GetConnectionProfile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GetConnectionProfileRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetConnectionProfile(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncCreateConnectionProfile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::CreateConnectionProfileRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateConnectionProfile(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::CreateConnectionProfile(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::CreateConnectionProfileRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateConnectionProfile(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncUpdateConnectionProfile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::UpdateConnectionProfileRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateConnectionProfile(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::UpdateConnectionProfile(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::UpdateConnectionProfileRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateConnectionProfile(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncDeleteConnectionProfile(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::DeleteConnectionProfileRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteConnectionProfile(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::DeleteConnectionProfile(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::DeleteConnectionProfileRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteConnectionProfile(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncCreatePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::CreatePrivateConnectionRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreatePrivateConnection(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::CreatePrivateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::CreatePrivateConnectionRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreatePrivateConnection(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::PrivateConnection>
DataMigrationServiceAuth::GetPrivateConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GetPrivateConnectionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetPrivateConnection(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::ListPrivateConnectionsResponse>
DataMigrationServiceAuth::ListPrivateConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::ListPrivateConnectionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListPrivateConnections(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncDeletePrivateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::DeletePrivateConnectionRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeletePrivateConnection(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::DeletePrivateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::DeletePrivateConnectionRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeletePrivateConnection(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>
DataMigrationServiceAuth::GetConversionWorkspace(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GetConversionWorkspaceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetConversionWorkspace(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::ListConversionWorkspacesResponse>
DataMigrationServiceAuth::ListConversionWorkspaces(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::ListConversionWorkspacesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListConversionWorkspaces(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncCreateConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::CreateConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::CreateConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::CreateConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateConversionWorkspace(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncUpdateConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::UpdateConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::UpdateConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::UpdateConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateConversionWorkspace(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncDeleteConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::DeleteConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::DeleteConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::DeleteConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteConversionWorkspace(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::MappingRule>
DataMigrationServiceAuth::CreateMappingRule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::CreateMappingRuleRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateMappingRule(context, options, request);
}

Status DataMigrationServiceAuth::DeleteMappingRule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::DeleteMappingRuleRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteMappingRule(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::ListMappingRulesResponse>
DataMigrationServiceAuth::ListMappingRules(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::ListMappingRulesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListMappingRules(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::MappingRule>
DataMigrationServiceAuth::GetMappingRule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::GetMappingRuleRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetMappingRule(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncSeedConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::SeedConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncSeedConversionWorkspace(cq, *std::move(context),
                                                   std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::SeedConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::SeedConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SeedConversionWorkspace(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncImportMappingRules(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::ImportMappingRulesRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncImportMappingRules(cq, *std::move(context),
                                              std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::ImportMappingRules(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::ImportMappingRulesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ImportMappingRules(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncConvertConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::ConvertConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncConvertConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::ConvertConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::ConvertConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ConvertConversionWorkspace(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncCommitConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::CommitConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCommitConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::CommitConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::CommitConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CommitConversionWorkspace(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncRollbackConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::RollbackConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncRollbackConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::RollbackConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::RollbackConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RollbackConversionWorkspace(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncApplyConversionWorkspace(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::clouddms::v1::ApplyConversionWorkspaceRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncApplyConversionWorkspace(
            cq, *std::move(context), std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
DataMigrationServiceAuth::ApplyConversionWorkspace(
    grpc::ClientContext& context, Options options,
    google::cloud::clouddms::v1::ApplyConversionWorkspaceRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ApplyConversionWorkspace(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::DescribeDatabaseEntitiesResponse>
DataMigrationServiceAuth::DescribeDatabaseEntities(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::DescribeDatabaseEntitiesRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DescribeDatabaseEntities(context, options, request);
}

StatusOr<google::cloud::clouddms::v1::SearchBackgroundJobsResponse>
DataMigrationServiceAuth::SearchBackgroundJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::SearchBackgroundJobsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchBackgroundJobs(context, options, request);
}

StatusOr<
    google::cloud::clouddms::v1::DescribeConversionWorkspaceRevisionsResponse>
DataMigrationServiceAuth::DescribeConversionWorkspaceRevisions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::
        DescribeConversionWorkspaceRevisionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DescribeConversionWorkspaceRevisions(context, options,
                                                      request);
}

StatusOr<google::cloud::clouddms::v1::FetchStaticIpsResponse>
DataMigrationServiceAuth::FetchStaticIps(
    grpc::ClientContext& context, Options const& options,
    google::cloud::clouddms::v1::FetchStaticIpsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchStaticIps(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
DataMigrationServiceAuth::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location>
DataMigrationServiceAuth::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetLocation(context, options, request);
}

StatusOr<google::iam::v1::Policy> DataMigrationServiceAuth::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> DataMigrationServiceAuth::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataMigrationServiceAuth::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
DataMigrationServiceAuth::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> DataMigrationServiceAuth::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOperation(context, options, request);
}

Status DataMigrationServiceAuth::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteOperation(context, options, request);
}

Status DataMigrationServiceAuth::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CancelOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataMigrationServiceAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context),
                                        std::move(options), request);
      });
}

future<Status> DataMigrationServiceAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context),
                                           std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datamigration_v1_internal
}  // namespace cloud
}  // namespace google
