// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/policytagmanager.proto

#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datacatalog_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PolicyTagManagerTracingConnection::PolicyTagManagerTracingConnection(
    std::shared_ptr<datacatalog_v1::PolicyTagManagerConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingConnection::CreateTaxonomy(
    google::cloud::datacatalog::v1::CreateTaxonomyRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::CreateTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTaxonomy(request));
}

Status PolicyTagManagerTracingConnection::DeleteTaxonomy(
    google::cloud::datacatalog::v1::DeleteTaxonomyRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::DeleteTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteTaxonomy(request));
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingConnection::UpdateTaxonomy(
    google::cloud::datacatalog::v1::UpdateTaxonomyRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::UpdateTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTaxonomy(request));
}

StreamRange<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingConnection::ListTaxonomies(
    google::cloud::datacatalog::v1::ListTaxonomiesRequest request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::ListTaxonomies");
  internal::OTelScope scope(span);
  auto sr = child_->ListTaxonomies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::datacatalog::v1::Taxonomy>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingConnection::GetTaxonomy(
    google::cloud::datacatalog::v1::GetTaxonomyRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::GetTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTaxonomy(request));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingConnection::CreatePolicyTag(
    google::cloud::datacatalog::v1::CreatePolicyTagRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::CreatePolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreatePolicyTag(request));
}

Status PolicyTagManagerTracingConnection::DeletePolicyTag(
    google::cloud::datacatalog::v1::DeletePolicyTagRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::DeletePolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeletePolicyTag(request));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingConnection::UpdatePolicyTag(
    google::cloud::datacatalog::v1::UpdatePolicyTagRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::UpdatePolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdatePolicyTag(request));
}

StreamRange<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingConnection::ListPolicyTags(
    google::cloud::datacatalog::v1::ListPolicyTagsRequest request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::ListPolicyTags");
  internal::OTelScope scope(span);
  auto sr = child_->ListPolicyTags(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::datacatalog::v1::PolicyTag>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingConnection::GetPolicyTag(
    google::cloud::datacatalog::v1::GetPolicyTagRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::GetPolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPolicyTag(request));
}

StatusOr<google::iam::v1::Policy>
PolicyTagManagerTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
PolicyTagManagerTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PolicyTagManagerTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
PolicyTagManagerTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
PolicyTagManagerTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status PolicyTagManagerTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status PolicyTagManagerTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "datacatalog_v1::PolicyTagManagerConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<datacatalog_v1::PolicyTagManagerConnection>
MakePolicyTagManagerTracingConnection(
    std::shared_ptr<datacatalog_v1::PolicyTagManagerConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<PolicyTagManagerTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1_internal
}  // namespace cloud
}  // namespace google
