// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/policytagmanager.proto

#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_connection_impl.h"
#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datacatalog_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<datacatalog_v1::PolicyTagManagerRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<datacatalog_v1::PolicyTagManagerRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<datacatalog_v1::PolicyTagManagerBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<datacatalog_v1::PolicyTagManagerConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<datacatalog_v1::PolicyTagManagerConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

PolicyTagManagerConnectionImpl::PolicyTagManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<datacatalog_v1_internal::PolicyTagManagerStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      PolicyTagManagerConnection::options())) {}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerConnectionImpl::CreateTaxonomy(
    google::cloud::datacatalog::v1::CreateTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTaxonomy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::datacatalog::v1::CreateTaxonomyRequest const&
                 request) {
        return stub_->CreateTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

Status PolicyTagManagerConnectionImpl::DeleteTaxonomy(
    google::cloud::datacatalog::v1::DeleteTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTaxonomy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::datacatalog::v1::DeleteTaxonomyRequest const&
                 request) {
        return stub_->DeleteTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerConnectionImpl::UpdateTaxonomy(
    google::cloud::datacatalog::v1::UpdateTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTaxonomy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::datacatalog::v1::UpdateTaxonomyRequest const&
                 request) {
        return stub_->UpdateTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerConnectionImpl::ListTaxonomies(
    google::cloud::datacatalog::v1::ListTaxonomiesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTaxonomies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::v1::Taxonomy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_v1::PolicyTagManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::datacatalog::v1::ListTaxonomiesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::datacatalog::v1::ListTaxonomiesRequest const&
                       request) {
              return stub->ListTaxonomies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::datacatalog::v1::ListTaxonomiesResponse r) {
        std::vector<google::cloud::datacatalog::v1::Taxonomy> result(
            r.taxonomies().size());
        auto& messages = *r.mutable_taxonomies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerConnectionImpl::GetTaxonomy(
    google::cloud::datacatalog::v1::GetTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTaxonomy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::datacatalog::v1::GetTaxonomyRequest const& request) {
        return stub_->GetTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerConnectionImpl::CreatePolicyTag(
    google::cloud::datacatalog::v1::CreatePolicyTagRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePolicyTag(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::datacatalog::v1::CreatePolicyTagRequest const&
                 request) {
        return stub_->CreatePolicyTag(context, options, request);
      },
      *current, request, __func__);
}

Status PolicyTagManagerConnectionImpl::DeletePolicyTag(
    google::cloud::datacatalog::v1::DeletePolicyTagRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePolicyTag(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::datacatalog::v1::DeletePolicyTagRequest const&
                 request) {
        return stub_->DeletePolicyTag(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerConnectionImpl::UpdatePolicyTag(
    google::cloud::datacatalog::v1::UpdatePolicyTagRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePolicyTag(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::datacatalog::v1::UpdatePolicyTagRequest const&
                 request) {
        return stub_->UpdatePolicyTag(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerConnectionImpl::ListPolicyTags(
    google::cloud::datacatalog::v1::ListPolicyTagsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPolicyTags(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::v1::PolicyTag>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_v1::PolicyTagManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::datacatalog::v1::ListPolicyTagsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::datacatalog::v1::ListPolicyTagsRequest const&
                       request) {
              return stub->ListPolicyTags(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::datacatalog::v1::ListPolicyTagsResponse r) {
        std::vector<google::cloud::datacatalog::v1::PolicyTag> result(
            r.policy_tags().size());
        auto& messages = *r.mutable_policy_tags();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerConnectionImpl::GetPolicyTag(
    google::cloud::datacatalog::v1::GetPolicyTagRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPolicyTag(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::datacatalog::v1::GetPolicyTagRequest const& request) {
        return stub_->GetPolicyTag(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PolicyTagManagerConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
PolicyTagManagerConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_v1::PolicyTagManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
PolicyTagManagerConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status PolicyTagManagerConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status PolicyTagManagerConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1_internal
}  // namespace cloud
}  // namespace google
