// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATACATALOG_LINEAGE_V1_INTERNAL_LINEAGE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATACATALOG_LINEAGE_V1_INTERNAL_LINEAGE_TRACING_CONNECTION_H

#include "google/cloud/datacatalog/lineage/v1/lineage_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_lineage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class LineageTracingConnection
    : public datacatalog_lineage_v1::LineageConnection {
 public:
  ~LineageTracingConnection() override = default;

  explicit LineageTracingConnection(
      std::shared_ptr<datacatalog_lineage_v1::LineageConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::datacatalog::lineage::v1::
               ProcessOpenLineageRunEventResponse>
  ProcessOpenLineageRunEvent(
      google::cloud::datacatalog::lineage::v1::
          ProcessOpenLineageRunEventRequest const& request) override;

  StatusOr<google::cloud::datacatalog::lineage::v1::Process> CreateProcess(
      google::cloud::datacatalog::lineage::v1::CreateProcessRequest const&
          request) override;

  StatusOr<google::cloud::datacatalog::lineage::v1::Process> UpdateProcess(
      google::cloud::datacatalog::lineage::v1::UpdateProcessRequest const&
          request) override;

  StatusOr<google::cloud::datacatalog::lineage::v1::Process> GetProcess(
      google::cloud::datacatalog::lineage::v1::GetProcessRequest const& request)
      override;

  StreamRange<google::cloud::datacatalog::lineage::v1::Process> ListProcesses(
      google::cloud::datacatalog::lineage::v1::ListProcessesRequest request)
      override;

  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteProcess(
      google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteProcess(
      NoAwaitTag,
      google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
          request) override;

  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteProcess(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::datacatalog::lineage::v1::Run> CreateRun(
      google::cloud::datacatalog::lineage::v1::CreateRunRequest const& request)
      override;

  StatusOr<google::cloud::datacatalog::lineage::v1::Run> UpdateRun(
      google::cloud::datacatalog::lineage::v1::UpdateRunRequest const& request)
      override;

  StatusOr<google::cloud::datacatalog::lineage::v1::Run> GetRun(
      google::cloud::datacatalog::lineage::v1::GetRunRequest const& request)
      override;

  StreamRange<google::cloud::datacatalog::lineage::v1::Run> ListRuns(
      google::cloud::datacatalog::lineage::v1::ListRunsRequest request)
      override;

  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteRun(google::cloud::datacatalog::lineage::v1::DeleteRunRequest const&
                request) override;

  StatusOr<google::longrunning::Operation> DeleteRun(
      NoAwaitTag,
      google::cloud::datacatalog::lineage::v1::DeleteRunRequest const& request)
      override;

  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteRun(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
  CreateLineageEvent(
      google::cloud::datacatalog::lineage::v1::CreateLineageEventRequest const&
          request) override;

  StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
  GetLineageEvent(
      google::cloud::datacatalog::lineage::v1::GetLineageEventRequest const&
          request) override;

  StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>
  ListLineageEvents(
      google::cloud::datacatalog::lineage::v1::ListLineageEventsRequest request)
      override;

  Status DeleteLineageEvent(
      google::cloud::datacatalog::lineage::v1::DeleteLineageEventRequest const&
          request) override;

  StreamRange<google::cloud::datacatalog::lineage::v1::Link> SearchLinks(
      google::cloud::datacatalog::lineage::v1::SearchLinksRequest request)
      override;

  StreamRange<google::cloud::datacatalog::lineage::v1::ProcessLinks>
  BatchSearchLinkProcesses(
      google::cloud::datacatalog::lineage::v1::BatchSearchLinkProcessesRequest
          request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<datacatalog_lineage_v1::LineageConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<datacatalog_lineage_v1::LineageConnection>
MakeLineageTracingConnection(
    std::shared_ptr<datacatalog_lineage_v1::LineageConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_lineage_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATACATALOG_LINEAGE_V1_INTERNAL_LINEAGE_TRACING_CONNECTION_H
