// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/ruleset_service.proto

#include "google/cloud/contentwarehouse/v1/rule_set_connection.h"
#include "google/cloud/contentwarehouse/v1/internal/rule_set_connection_impl.h"
#include "google/cloud/contentwarehouse/v1/internal/rule_set_option_defaults.h"
#include "google/cloud/contentwarehouse/v1/internal/rule_set_stub_factory.h"
#include "google/cloud/contentwarehouse/v1/internal/rule_set_tracing_connection.h"
#include "google/cloud/contentwarehouse/v1/rule_set_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RuleSetServiceConnection::~RuleSetServiceConnection() = default;

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceConnection::CreateRuleSet(
    google::cloud::contentwarehouse::v1::CreateRuleSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceConnection::GetRuleSet(
    google::cloud::contentwarehouse::v1::GetRuleSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceConnection::UpdateRuleSet(
    google::cloud::contentwarehouse::v1::UpdateRuleSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status RuleSetServiceConnection::DeleteRuleSet(
    google::cloud::contentwarehouse::v1::DeleteRuleSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceConnection::ListRuleSets(
    google::cloud::contentwarehouse::v1::
        ListRuleSetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::contentwarehouse::v1::RuleSet>>();
}

StatusOr<google::longrunning::Operation> RuleSetServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<RuleSetServiceConnection> MakeRuleSetServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 RuleSetServicePolicyOptionList>(options,
                                                                 __func__);
  options = contentwarehouse_v1_internal::RuleSetServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = contentwarehouse_v1_internal::CreateDefaultRuleSetServiceStub(
      std::move(auth), options);
  return contentwarehouse_v1_internal::MakeRuleSetServiceTracingConnection(
      std::make_shared<
          contentwarehouse_v1_internal::RuleSetServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
