// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/pipeline_service.proto

#include "google/cloud/contentwarehouse/v1/internal/pipeline_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PipelineServiceTracingConnection::PipelineServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::PipelineServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::contentwarehouse::v1::RunPipelineResponse>>
PipelineServiceTracingConnection::RunPipeline(
    google::cloud::contentwarehouse::v1::RunPipelineRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::PipelineServiceConnection::RunPipeline");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RunPipeline(request));
}

StatusOr<google::longrunning::Operation>
PipelineServiceTracingConnection::RunPipeline(
    NoAwaitTag,
    google::cloud::contentwarehouse::v1::RunPipelineRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::PipelineServiceConnection::RunPipeline");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RunPipeline(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::contentwarehouse::v1::RunPipelineResponse>>
PipelineServiceTracingConnection::RunPipeline(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::PipelineServiceConnection::RunPipeline");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RunPipeline(operation));
}

StatusOr<google::longrunning::Operation>
PipelineServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::PipelineServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<contentwarehouse_v1::PipelineServiceConnection>
MakePipelineServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::PipelineServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<PipelineServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
