// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentServiceTracingConnection::DocumentServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::DocumentServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::contentwarehouse::v1::CreateDocumentResponse>
DocumentServiceTracingConnection::CreateDocument(
    google::cloud::contentwarehouse::v1::CreateDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::CreateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDocument(request));
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceTracingConnection::GetDocument(
    google::cloud::contentwarehouse::v1::GetDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::GetDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDocument(request));
}

StatusOr<google::cloud::contentwarehouse::v1::UpdateDocumentResponse>
DocumentServiceTracingConnection::UpdateDocument(
    google::cloud::contentwarehouse::v1::UpdateDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::UpdateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDocument(request));
}

Status DocumentServiceTracingConnection::DeleteDocument(
    google::cloud::contentwarehouse::v1::DeleteDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::DeleteDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDocument(request));
}

StreamRange<google::cloud::contentwarehouse::v1::SearchDocumentsResponse::
                MatchingDocument>
DocumentServiceTracingConnection::SearchDocuments(
    google::cloud::contentwarehouse::v1::SearchDocumentsRequest request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::SearchDocuments");
  internal::OTelScope scope(span);
  auto sr = child_->SearchDocuments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contentwarehouse::v1::SearchDocumentsResponse::
          MatchingDocument>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceTracingConnection::LockDocument(
    google::cloud::contentwarehouse::v1::LockDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::LockDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->LockDocument(request));
}

StatusOr<google::cloud::contentwarehouse::v1::FetchAclResponse>
DocumentServiceTracingConnection::FetchAcl(
    google::cloud::contentwarehouse::v1::FetchAclRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::FetchAcl");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchAcl(request));
}

StatusOr<google::cloud::contentwarehouse::v1::SetAclResponse>
DocumentServiceTracingConnection::SetAcl(
    google::cloud::contentwarehouse::v1::SetAclRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::SetAcl");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetAcl(request));
}

StatusOr<google::longrunning::Operation>
DocumentServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<contentwarehouse_v1::DocumentServiceConnection>
MakeDocumentServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::DocumentServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DocumentServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
