// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

#include "google/cloud/contentwarehouse/v1/document_schema_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentSchemaServiceClient::DocumentSchemaServiceClient(
    std::shared_ptr<DocumentSchemaServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DocumentSchemaServiceClient::~DocumentSchemaServiceClient() = default;

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::CreateDocumentSchema(
    std::string const& parent,
    google::cloud::contentwarehouse::v1::DocumentSchema const& document_schema,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest request;
  request.set_parent(parent);
  *request.mutable_document_schema() = document_schema;
  return connection_->CreateDocumentSchema(request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::CreateDocumentSchema(
    google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDocumentSchema(request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::UpdateDocumentSchema(
    std::string const& name,
    google::cloud::contentwarehouse::v1::DocumentSchema const& document_schema,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest request;
  request.set_name(name);
  *request.mutable_document_schema() = document_schema;
  return connection_->UpdateDocumentSchema(request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::UpdateDocumentSchema(
    google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDocumentSchema(request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::GetDocumentSchema(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest request;
  request.set_name(name);
  return connection_->GetDocumentSchema(request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::GetDocumentSchema(
    google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDocumentSchema(request);
}

Status DocumentSchemaServiceClient::DeleteDocumentSchema(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest request;
  request.set_name(name);
  return connection_->DeleteDocumentSchema(request);
}

Status DocumentSchemaServiceClient::DeleteDocumentSchema(
    google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDocumentSchema(request);
}

StreamRange<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::ListDocumentSchemas(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::ListDocumentSchemasRequest request;
  request.set_parent(parent);
  return connection_->ListDocumentSchemas(request);
}

StreamRange<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceClient::ListDocumentSchemas(
    google::cloud::contentwarehouse::v1::ListDocumentSchemasRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDocumentSchemas(std::move(request));
}

StatusOr<google::longrunning::Operation>
DocumentSchemaServiceClient::GetOperation(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
DocumentSchemaServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
