// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_service.proto

#include "google/cloud/contentwarehouse/v1/document_connection.h"
#include "google/cloud/contentwarehouse/v1/document_options.h"
#include "google/cloud/contentwarehouse/v1/internal/document_connection_impl.h"
#include "google/cloud/contentwarehouse/v1/internal/document_option_defaults.h"
#include "google/cloud/contentwarehouse/v1/internal/document_stub_factory.h"
#include "google/cloud/contentwarehouse/v1/internal/document_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentServiceConnection::~DocumentServiceConnection() = default;

StatusOr<google::cloud::contentwarehouse::v1::CreateDocumentResponse>
DocumentServiceConnection::CreateDocument(
    google::cloud::contentwarehouse::v1::CreateDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceConnection::GetDocument(
    google::cloud::contentwarehouse::v1::GetDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::contentwarehouse::v1::UpdateDocumentResponse>
DocumentServiceConnection::UpdateDocument(
    google::cloud::contentwarehouse::v1::UpdateDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DocumentServiceConnection::DeleteDocument(
    google::cloud::contentwarehouse::v1::DeleteDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::contentwarehouse::v1::SearchDocumentsResponse::
                MatchingDocument>
DocumentServiceConnection::SearchDocuments(
    google::cloud::contentwarehouse::v1::
        SearchDocumentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::contentwarehouse::v1::SearchDocumentsResponse::
                      MatchingDocument>>();
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceConnection::LockDocument(
    google::cloud::contentwarehouse::v1::LockDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::contentwarehouse::v1::FetchAclResponse>
DocumentServiceConnection::FetchAcl(
    google::cloud::contentwarehouse::v1::FetchAclRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::contentwarehouse::v1::SetAclResponse>
DocumentServiceConnection::SetAcl(
    google::cloud::contentwarehouse::v1::SetAclRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::longrunning::Operation>
DocumentServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DocumentServiceConnection> MakeDocumentServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DocumentServicePolicyOptionList>(options,
                                                                  __func__);
  options = contentwarehouse_v1_internal::DocumentServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = contentwarehouse_v1_internal::CreateDefaultDocumentServiceStub(
      std::move(auth), options);
  return contentwarehouse_v1_internal::MakeDocumentServiceTracingConnection(
      std::make_shared<
          contentwarehouse_v1_internal::DocumentServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
