// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

#include "google/cloud/contactcenterinsights/v1/internal/contact_center_insights_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contactcenterinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ContactCenterInsightsTracingStub::ContactCenterInsightsTracingStub(
    std::shared_ptr<ContactCenterInsightsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingStub::CreateConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::CreateConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreateConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateConversation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncUploadConversation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UploadConversation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUploadConversation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::UploadConversation(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UploadConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UploadConversation(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingStub::UpdateConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::UpdateConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UpdateConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateConversation(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsTracingStub::GetConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetConversation(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListConversationsResponse>
ContactCenterInsightsTracingStub::ListConversations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::ListConversationsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListConversations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListConversations(context, options, request));
}

Status ContactCenterInsightsTracingStub::DeleteConversation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::DeleteConversationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeleteConversation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteConversation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncCreateAnalysis(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreateAnalysis");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateAnalysis(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::CreateAnalysis(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreateAnalysis");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateAnalysis(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsTracingStub::GetAnalysis(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetAnalysisRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetAnalysis");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAnalysis(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListAnalysesResponse>
ContactCenterInsightsTracingStub::ListAnalyses(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::ListAnalysesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListAnalyses");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAnalyses(context, options, request));
}

Status ContactCenterInsightsTracingStub::DeleteAnalysis(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::DeleteAnalysisRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeleteAnalysis");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAnalysis(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncBulkAnalyzeConversations(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::
        BulkAnalyzeConversationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "BulkAnalyzeConversations");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBulkAnalyzeConversations(cq, context,
                                                 std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::BulkAnalyzeConversations(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::
        BulkAnalyzeConversationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "BulkAnalyzeConversations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->BulkAnalyzeConversations(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncBulkDeleteConversations(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::
        BulkDeleteConversationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "BulkDeleteConversations");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncBulkDeleteConversations(cq, context, std::move(options),
                                                request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::BulkDeleteConversations(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::
        BulkDeleteConversationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "BulkDeleteConversations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->BulkDeleteConversations(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncIngestConversations(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "IngestConversations");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncIngestConversations(cq, context, std::move(options),
                                            request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::IngestConversations(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "IngestConversations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->IngestConversations(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncExportInsightsData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ExportInsightsData");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncExportInsightsData(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::ExportInsightsData(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ExportInsightsData");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ExportInsightsData(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncCreateIssueModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreateIssueModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateIssueModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::CreateIssueModel(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreateIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateIssueModel(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsTracingStub::UpdateIssueModel(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::UpdateIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UpdateIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateIssueModel(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsTracingStub::GetIssueModel(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIssueModel(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssueModelsResponse>
ContactCenterInsightsTracingStub::ListIssueModels(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::ListIssueModelsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListIssueModels");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListIssueModels(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncDeleteIssueModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeleteIssueModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteIssueModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::DeleteIssueModel(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeleteIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteIssueModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncDeployIssueModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeployIssueModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeployIssueModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::DeployIssueModel(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeployIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeployIssueModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncUndeployIssueModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UndeployIssueModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUndeployIssueModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::UndeployIssueModel(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UndeployIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UndeployIssueModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncExportIssueModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::ExportIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ExportIssueModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncExportIssueModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::ExportIssueModel(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::ExportIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ExportIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportIssueModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncImportIssueModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::ImportIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ImportIssueModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncImportIssueModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::ImportIssueModel(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::ImportIssueModelRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ImportIssueModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ImportIssueModel(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsTracingStub::GetIssue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetIssueRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetIssue");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIssue(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssuesResponse>
ContactCenterInsightsTracingStub::ListIssues(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::ListIssuesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListIssues");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListIssues(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsTracingStub::UpdateIssue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::UpdateIssueRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UpdateIssue");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateIssue(context, options, request));
}

Status ContactCenterInsightsTracingStub::DeleteIssue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::DeleteIssueRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeleteIssue");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteIssue(context, options, request));
}

StatusOr<
    google::cloud::contactcenterinsights::v1::CalculateIssueModelStatsResponse>
ContactCenterInsightsTracingStub::CalculateIssueModelStats(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::
        CalculateIssueModelStatsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CalculateIssueModelStats");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CalculateIssueModelStats(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingStub::CreatePhraseMatcher(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::CreatePhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreatePhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreatePhraseMatcher(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingStub::GetPhraseMatcher(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetPhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetPhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPhraseMatcher(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListPhraseMatchersResponse>
ContactCenterInsightsTracingStub::ListPhraseMatchers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::ListPhraseMatchersRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListPhraseMatchers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListPhraseMatchers(context, options, request));
}

Status ContactCenterInsightsTracingStub::DeletePhraseMatcher(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::DeletePhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeletePhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeletePhraseMatcher(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsTracingStub::UpdatePhraseMatcher(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::UpdatePhraseMatcherRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UpdatePhraseMatcher");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdatePhraseMatcher(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::CalculateStatsResponse>
ContactCenterInsightsTracingStub::CalculateStats(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::CalculateStatsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CalculateStats");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CalculateStats(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsTracingStub::GetSettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSettings(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsTracingStub::UpdateSettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::UpdateSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UpdateSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateSettings(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::EncryptionSpec>
ContactCenterInsightsTracingStub::GetEncryptionSpec(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetEncryptionSpecRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetEncryptionSpec");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetEncryptionSpec(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncInitializeEncryptionSpec(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::contactcenterinsights::v1::
        InitializeEncryptionSpecRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "InitializeEncryptionSpec");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncInitializeEncryptionSpec(cq, context,
                                                 std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::InitializeEncryptionSpec(
    grpc::ClientContext& context, Options options,
    google::cloud::contactcenterinsights::v1::
        InitializeEncryptionSpecRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "InitializeEncryptionSpec");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->InitializeEncryptionSpec(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingStub::CreateView(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::CreateViewRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CreateView");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateView(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingStub::GetView(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::GetViewRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights", "GetView");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetView(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::ListViewsResponse>
ContactCenterInsightsTracingStub::ListViews(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::ListViewsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListViews");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListViews(context, options, request));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsTracingStub::UpdateView(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::UpdateViewRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "UpdateView");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateView(context, options, request));
}

Status ContactCenterInsightsTracingStub::DeleteView(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contactcenterinsights::v1::DeleteViewRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "DeleteView");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteView(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
ContactCenterInsightsTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status ContactCenterInsightsTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contactcenterinsights.v1.ContactCenterInsights",
      "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ContactCenterInsightsTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> ContactCenterInsightsTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ContactCenterInsightsStub> MakeContactCenterInsightsTracingStub(
    std::shared_ptr<ContactCenterInsightsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ContactCenterInsightsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contactcenterinsights_v1_internal
}  // namespace cloud
}  // namespace google
