// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

#include "google/cloud/contactcenterinsights/v1/contact_center_insights_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contactcenterinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ContactCenterInsightsClient::ContactCenterInsightsClient(
    std::shared_ptr<ContactCenterInsightsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ContactCenterInsightsClient::~ContactCenterInsightsClient() = default;

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::CreateConversation(
    std::string const& parent,
    google::cloud::contactcenterinsights::v1::Conversation const& conversation,
    std::string const& conversation_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreateConversationRequest request;
  request.set_parent(parent);
  *request.mutable_conversation() = conversation;
  request.set_conversation_id(conversation_id);
  return connection_->CreateConversation(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::CreateConversation(
    google::cloud::contactcenterinsights::v1::CreateConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversation(request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>
ContactCenterInsightsClient::UploadConversation(
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UploadConversation(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::UploadConversation(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UploadConversation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>
ContactCenterInsightsClient::UploadConversation(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UploadConversation(operation);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::UpdateConversation(
    google::cloud::contactcenterinsights::v1::Conversation const& conversation,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UpdateConversationRequest request;
  *request.mutable_conversation() = conversation;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateConversation(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::UpdateConversation(
    google::cloud::contactcenterinsights::v1::UpdateConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConversation(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::GetConversation(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetConversationRequest request;
  request.set_name(name);
  return connection_->GetConversation(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::GetConversation(
    google::cloud::contactcenterinsights::v1::GetConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConversation(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::ListConversations(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ListConversationsRequest request;
  request.set_parent(parent);
  return connection_->ListConversations(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsClient::ListConversations(
    google::cloud::contactcenterinsights::v1::ListConversationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConversations(std::move(request));
}

Status ContactCenterInsightsClient::DeleteConversation(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeleteConversationRequest request;
  request.set_name(name);
  return connection_->DeleteConversation(request);
}

Status ContactCenterInsightsClient::DeleteConversation(
    google::cloud::contactcenterinsights::v1::DeleteConversationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversation(request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsClient::CreateAnalysis(
    std::string const& parent,
    google::cloud::contactcenterinsights::v1::Analysis const& analysis,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreateAnalysisRequest request;
  request.set_parent(parent);
  *request.mutable_analysis() = analysis;
  return connection_->CreateAnalysis(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::CreateAnalysis(
    NoAwaitTag, std::string const& parent,
    google::cloud::contactcenterinsights::v1::Analysis const& analysis,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreateAnalysisRequest request;
  request.set_parent(parent);
  *request.mutable_analysis() = analysis;
  return connection_->CreateAnalysis(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsClient::CreateAnalysis(
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAnalysis(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::CreateAnalysis(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAnalysis(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsClient::CreateAnalysis(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAnalysis(operation);
}

StatusOr<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsClient::GetAnalysis(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetAnalysisRequest request;
  request.set_name(name);
  return connection_->GetAnalysis(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsClient::GetAnalysis(
    google::cloud::contactcenterinsights::v1::GetAnalysisRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAnalysis(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsClient::ListAnalyses(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ListAnalysesRequest request;
  request.set_parent(parent);
  return connection_->ListAnalyses(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsClient::ListAnalyses(
    google::cloud::contactcenterinsights::v1::ListAnalysesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAnalyses(std::move(request));
}

Status ContactCenterInsightsClient::DeleteAnalysis(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeleteAnalysisRequest request;
  request.set_name(name);
  return connection_->DeleteAnalysis(request);
}

Status ContactCenterInsightsClient::DeleteAnalysis(
    google::cloud::contactcenterinsights::v1::DeleteAnalysisRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAnalysis(request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsClient::BulkAnalyzeConversations(std::string const& parent,
                                                      std::string const& filter,
                                                      float analysis_percentage,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsRequest
      request;
  request.set_parent(parent);
  request.set_filter(filter);
  request.set_analysis_percentage(analysis_percentage);
  return connection_->BulkAnalyzeConversations(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::BulkAnalyzeConversations(NoAwaitTag,
                                                      std::string const& parent,
                                                      std::string const& filter,
                                                      float analysis_percentage,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsRequest
      request;
  request.set_parent(parent);
  request.set_filter(filter);
  request.set_analysis_percentage(analysis_percentage);
  return connection_->BulkAnalyzeConversations(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsClient::BulkAnalyzeConversations(
    google::cloud::contactcenterinsights::v1::
        BulkAnalyzeConversationsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkAnalyzeConversations(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::BulkAnalyzeConversations(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::
        BulkAnalyzeConversationsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkAnalyzeConversations(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsClient::BulkAnalyzeConversations(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkAnalyzeConversations(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsClient::BulkDeleteConversations(std::string const& parent,
                                                     std::string const& filter,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::BulkDeleteConversationsRequest
      request;
  request.set_parent(parent);
  request.set_filter(filter);
  return connection_->BulkDeleteConversations(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::BulkDeleteConversations(NoAwaitTag,
                                                     std::string const& parent,
                                                     std::string const& filter,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::BulkDeleteConversationsRequest
      request;
  request.set_parent(parent);
  request.set_filter(filter);
  return connection_->BulkDeleteConversations(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsClient::BulkDeleteConversations(
    google::cloud::contactcenterinsights::v1::
        BulkDeleteConversationsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkDeleteConversations(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::BulkDeleteConversations(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::
        BulkDeleteConversationsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkDeleteConversations(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsClient::BulkDeleteConversations(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkDeleteConversations(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsClient::IngestConversations(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::IngestConversationsRequest request;
  request.set_parent(parent);
  return connection_->IngestConversations(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::IngestConversations(NoAwaitTag,
                                                 std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::IngestConversationsRequest request;
  request.set_parent(parent);
  return connection_->IngestConversations(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsClient::IngestConversations(
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->IngestConversations(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::IngestConversations(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->IngestConversations(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsClient::IngestConversations(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->IngestConversations(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsClient::ExportInsightsData(std::string const& parent,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest request;
  request.set_parent(parent);
  return connection_->ExportInsightsData(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::ExportInsightsData(NoAwaitTag,
                                                std::string const& parent,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest request;
  request.set_parent(parent);
  return connection_->ExportInsightsData(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsClient::ExportInsightsData(
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportInsightsData(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::ExportInsightsData(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportInsightsData(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsClient::ExportInsightsData(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportInsightsData(operation);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsClient::CreateIssueModel(
    std::string const& parent,
    google::cloud::contactcenterinsights::v1::IssueModel const& issue_model,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreateIssueModelRequest request;
  request.set_parent(parent);
  *request.mutable_issue_model() = issue_model;
  return connection_->CreateIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::CreateIssueModel(
    NoAwaitTag, std::string const& parent,
    google::cloud::contactcenterinsights::v1::IssueModel const& issue_model,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreateIssueModelRequest request;
  request.set_parent(parent);
  *request.mutable_issue_model() = issue_model;
  return connection_->CreateIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsClient::CreateIssueModel(
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::CreateIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsClient::CreateIssueModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIssueModel(operation);
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsClient::UpdateIssueModel(
    google::cloud::contactcenterinsights::v1::IssueModel const& issue_model,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UpdateIssueModelRequest request;
  *request.mutable_issue_model() = issue_model;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateIssueModel(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsClient::UpdateIssueModel(
    google::cloud::contactcenterinsights::v1::UpdateIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIssueModel(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsClient::GetIssueModel(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetIssueModelRequest request;
  request.set_name(name);
  return connection_->GetIssueModel(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsClient::GetIssueModel(
    google::cloud::contactcenterinsights::v1::GetIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIssueModel(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssueModelsResponse>
ContactCenterInsightsClient::ListIssueModels(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ListIssueModelsRequest request;
  request.set_parent(parent);
  return connection_->ListIssueModels(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssueModelsResponse>
ContactCenterInsightsClient::ListIssueModels(
    google::cloud::contactcenterinsights::v1::ListIssueModelsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListIssueModels(request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsClient::DeleteIssueModel(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest request;
  request.set_name(name);
  return connection_->DeleteIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::DeleteIssueModel(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest request;
  request.set_name(name);
  return connection_->DeleteIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsClient::DeleteIssueModel(
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::DeleteIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsClient::DeleteIssueModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIssueModel(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsClient::DeployIssueModel(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeployIssueModelRequest request;
  request.set_name(name);
  return connection_->DeployIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::DeployIssueModel(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeployIssueModelRequest request;
  request.set_name(name);
  return connection_->DeployIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsClient::DeployIssueModel(
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::DeployIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsClient::DeployIssueModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployIssueModel(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsClient::UndeployIssueModel(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest request;
  request.set_name(name);
  return connection_->UndeployIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::UndeployIssueModel(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest request;
  request.set_name(name);
  return connection_->UndeployIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsClient::UndeployIssueModel(
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::UndeployIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsClient::UndeployIssueModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployIssueModel(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportIssueModelResponse>>
ContactCenterInsightsClient::ExportIssueModel(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ExportIssueModelRequest request;
  request.set_name(name);
  return connection_->ExportIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::ExportIssueModel(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ExportIssueModelRequest request;
  request.set_name(name);
  return connection_->ExportIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportIssueModelResponse>>
ContactCenterInsightsClient::ExportIssueModel(
    google::cloud::contactcenterinsights::v1::ExportIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::ExportIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::ExportIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportIssueModelResponse>>
ContactCenterInsightsClient::ExportIssueModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportIssueModel(operation);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ImportIssueModelResponse>>
ContactCenterInsightsClient::ImportIssueModel(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ImportIssueModelRequest request;
  request.set_parent(parent);
  return connection_->ImportIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::ImportIssueModel(NoAwaitTag,
                                              std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ImportIssueModelRequest request;
  request.set_parent(parent);
  return connection_->ImportIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ImportIssueModelResponse>>
ContactCenterInsightsClient::ImportIssueModel(
    google::cloud::contactcenterinsights::v1::ImportIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportIssueModel(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::ImportIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::ImportIssueModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportIssueModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ImportIssueModelResponse>>
ContactCenterInsightsClient::ImportIssueModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportIssueModel(operation);
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsClient::GetIssue(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetIssueRequest request;
  request.set_name(name);
  return connection_->GetIssue(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsClient::GetIssue(
    google::cloud::contactcenterinsights::v1::GetIssueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIssue(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssuesResponse>
ContactCenterInsightsClient::ListIssues(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ListIssuesRequest request;
  request.set_parent(parent);
  return connection_->ListIssues(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssuesResponse>
ContactCenterInsightsClient::ListIssues(
    google::cloud::contactcenterinsights::v1::ListIssuesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListIssues(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsClient::UpdateIssue(
    google::cloud::contactcenterinsights::v1::Issue const& issue,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UpdateIssueRequest request;
  *request.mutable_issue() = issue;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateIssue(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsClient::UpdateIssue(
    google::cloud::contactcenterinsights::v1::UpdateIssueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateIssue(request);
}

Status ContactCenterInsightsClient::DeleteIssue(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeleteIssueRequest request;
  request.set_name(name);
  return connection_->DeleteIssue(request);
}

Status ContactCenterInsightsClient::DeleteIssue(
    google::cloud::contactcenterinsights::v1::DeleteIssueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIssue(request);
}

StatusOr<
    google::cloud::contactcenterinsights::v1::CalculateIssueModelStatsResponse>
ContactCenterInsightsClient::CalculateIssueModelStats(
    std::string const& issue_model, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CalculateIssueModelStatsRequest
      request;
  request.set_issue_model(issue_model);
  return connection_->CalculateIssueModelStats(request);
}

StatusOr<
    google::cloud::contactcenterinsights::v1::CalculateIssueModelStatsResponse>
ContactCenterInsightsClient::CalculateIssueModelStats(
    google::cloud::contactcenterinsights::v1::
        CalculateIssueModelStatsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CalculateIssueModelStats(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::CreatePhraseMatcher(
    std::string const& parent,
    google::cloud::contactcenterinsights::v1::PhraseMatcher const&
        phrase_matcher,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreatePhraseMatcherRequest request;
  request.set_parent(parent);
  *request.mutable_phrase_matcher() = phrase_matcher;
  return connection_->CreatePhraseMatcher(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::CreatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::CreatePhraseMatcherRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePhraseMatcher(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::GetPhraseMatcher(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetPhraseMatcherRequest request;
  request.set_name(name);
  return connection_->GetPhraseMatcher(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::GetPhraseMatcher(
    google::cloud::contactcenterinsights::v1::GetPhraseMatcherRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPhraseMatcher(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::ListPhraseMatchers(std::string const& parent,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ListPhraseMatchersRequest request;
  request.set_parent(parent);
  return connection_->ListPhraseMatchers(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::ListPhraseMatchers(
    google::cloud::contactcenterinsights::v1::ListPhraseMatchersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPhraseMatchers(std::move(request));
}

Status ContactCenterInsightsClient::DeletePhraseMatcher(std::string const& name,
                                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeletePhraseMatcherRequest request;
  request.set_name(name);
  return connection_->DeletePhraseMatcher(request);
}

Status ContactCenterInsightsClient::DeletePhraseMatcher(
    google::cloud::contactcenterinsights::v1::DeletePhraseMatcherRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePhraseMatcher(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::UpdatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::PhraseMatcher const&
        phrase_matcher,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UpdatePhraseMatcherRequest request;
  *request.mutable_phrase_matcher() = phrase_matcher;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePhraseMatcher(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsClient::UpdatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::UpdatePhraseMatcherRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePhraseMatcher(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::CalculateStatsResponse>
ContactCenterInsightsClient::CalculateStats(std::string const& location,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CalculateStatsRequest request;
  request.set_location(location);
  return connection_->CalculateStats(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::CalculateStatsResponse>
ContactCenterInsightsClient::CalculateStats(
    google::cloud::contactcenterinsights::v1::CalculateStatsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CalculateStats(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsClient::GetSettings(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetSettingsRequest request;
  request.set_name(name);
  return connection_->GetSettings(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsClient::GetSettings(
    google::cloud::contactcenterinsights::v1::GetSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSettings(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsClient::UpdateSettings(
    google::cloud::contactcenterinsights::v1::Settings const& settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UpdateSettingsRequest request;
  *request.mutable_settings() = settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSettings(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsClient::UpdateSettings(
    google::cloud::contactcenterinsights::v1::UpdateSettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSettings(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::EncryptionSpec>
ContactCenterInsightsClient::GetEncryptionSpec(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetEncryptionSpecRequest request;
  request.set_name(name);
  return connection_->GetEncryptionSpec(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::EncryptionSpec>
ContactCenterInsightsClient::GetEncryptionSpec(
    google::cloud::contactcenterinsights::v1::GetEncryptionSpecRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEncryptionSpec(request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::InitializeEncryptionSpecResponse>>
ContactCenterInsightsClient::InitializeEncryptionSpec(
    google::cloud::contactcenterinsights::v1::EncryptionSpec const&
        encryption_spec,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::InitializeEncryptionSpecRequest
      request;
  *request.mutable_encryption_spec() = encryption_spec;
  return connection_->InitializeEncryptionSpec(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::InitializeEncryptionSpec(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::EncryptionSpec const&
        encryption_spec,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::InitializeEncryptionSpecRequest
      request;
  *request.mutable_encryption_spec() = encryption_spec;
  return connection_->InitializeEncryptionSpec(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::InitializeEncryptionSpecResponse>>
ContactCenterInsightsClient::InitializeEncryptionSpec(
    google::cloud::contactcenterinsights::v1::
        InitializeEncryptionSpecRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InitializeEncryptionSpec(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::InitializeEncryptionSpec(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::
        InitializeEncryptionSpecRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InitializeEncryptionSpec(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::InitializeEncryptionSpecResponse>>
ContactCenterInsightsClient::InitializeEncryptionSpec(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InitializeEncryptionSpec(operation);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::CreateView(
    std::string const& parent,
    google::cloud::contactcenterinsights::v1::View const& view, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::CreateViewRequest request;
  request.set_parent(parent);
  *request.mutable_view() = view;
  return connection_->CreateView(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::CreateView(
    google::cloud::contactcenterinsights::v1::CreateViewRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateView(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::GetView(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::GetViewRequest request;
  request.set_name(name);
  return connection_->GetView(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::GetView(
    google::cloud::contactcenterinsights::v1::GetViewRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetView(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::ListViews(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::ListViewsRequest request;
  request.set_parent(parent);
  return connection_->ListViews(request);
}

StreamRange<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::ListViews(
    google::cloud::contactcenterinsights::v1::ListViewsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListViews(std::move(request));
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::UpdateView(
    google::cloud::contactcenterinsights::v1::View const& view,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::UpdateViewRequest request;
  *request.mutable_view() = view;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateView(request);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsClient::UpdateView(
    google::cloud::contactcenterinsights::v1::UpdateViewRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateView(request);
}

Status ContactCenterInsightsClient::DeleteView(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contactcenterinsights::v1::DeleteViewRequest request;
  request.set_name(name);
  return connection_->DeleteView(request);
}

Status ContactCenterInsightsClient::DeleteView(
    google::cloud::contactcenterinsights::v1::DeleteViewRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteView(request);
}

StreamRange<google::longrunning::Operation>
ContactCenterInsightsClient::ListOperations(std::string const& name,
                                            std::string const& filter,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
ContactCenterInsightsClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::GetOperation(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status ContactCenterInsightsClient::CancelOperation(std::string const& name,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status ContactCenterInsightsClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contactcenterinsights_v1
}  // namespace cloud
}  // namespace google
