// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/connectors/v1/connectors_service.proto

#include "google/cloud/connectors/v1/internal/connectors_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/connectors/v1/connectors_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace connectors_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConnectorsLogging::ConnectorsLogging(std::shared_ptr<ConnectorsStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::connectors::v1::ListConnectionsResponse>
ConnectorsLogging::ListConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::ListConnectionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::ListConnectionsRequest const&
                 request) {
        return child_->ListConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::Connection>
ConnectorsLogging::GetConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::connectors::v1::GetConnectionRequest const& request) {
        return child_->GetConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ConnectorsLogging::AsyncCreateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::connectors::v1::CreateConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::connectors::v1::CreateConnectionRequest const&
                 request) {
        return child_->AsyncCreateConnection(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> ConnectorsLogging::CreateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::connectors::v1::CreateConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::CreateConnectionRequest const&
                 request) {
        return child_->CreateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ConnectorsLogging::AsyncUpdateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::connectors::v1::UpdateConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::connectors::v1::UpdateConnectionRequest const&
                 request) {
        return child_->AsyncUpdateConnection(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> ConnectorsLogging::UpdateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::connectors::v1::UpdateConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::UpdateConnectionRequest const&
                 request) {
        return child_->UpdateConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ConnectorsLogging::AsyncDeleteConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::connectors::v1::DeleteConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::connectors::v1::DeleteConnectionRequest const&
                 request) {
        return child_->AsyncDeleteConnection(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> ConnectorsLogging::DeleteConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::connectors::v1::DeleteConnectionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::DeleteConnectionRequest const&
                 request) {
        return child_->DeleteConnection(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ListProvidersResponse>
ConnectorsLogging::ListProviders(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::ListProvidersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::connectors::v1::ListProvidersRequest const& request) {
        return child_->ListProviders(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::Provider>
ConnectorsLogging::GetProvider(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetProviderRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::GetProviderRequest const& request) {
        return child_->GetProvider(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ListConnectorsResponse>
ConnectorsLogging::ListConnectors(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::ListConnectorsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::connectors::v1::ListConnectorsRequest const& request) {
        return child_->ListConnectors(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::Connector>
ConnectorsLogging::GetConnector(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetConnectorRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::connectors::v1::GetConnectorRequest const& request) {
        return child_->GetConnector(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ListConnectorVersionsResponse>
ConnectorsLogging::ListConnectorVersions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::ListConnectorVersionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::ListConnectorVersionsRequest const&
                 request) {
        return child_->ListConnectorVersions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ConnectorVersion>
ConnectorsLogging::GetConnectorVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetConnectorVersionRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::GetConnectorVersionRequest const&
                 request) {
        return child_->GetConnectorVersion(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ConnectionSchemaMetadata>
ConnectorsLogging::GetConnectionSchemaMetadata(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetConnectionSchemaMetadataRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::
                 GetConnectionSchemaMetadataRequest const& request) {
        return child_->GetConnectionSchemaMetadata(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ConnectorsLogging::AsyncRefreshConnectionSchemaMetadata(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::connectors::v1::RefreshConnectionSchemaMetadataRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::connectors::v1::
                 RefreshConnectionSchemaMetadataRequest const& request) {
        return child_->AsyncRefreshConnectionSchemaMetadata(
            cq, std::move(context), std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ConnectorsLogging::RefreshConnectionSchemaMetadata(
    grpc::ClientContext& context, Options options,
    google::cloud::connectors::v1::RefreshConnectionSchemaMetadataRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::
                 RefreshConnectionSchemaMetadataRequest const& request) {
        return child_->RefreshConnectionSchemaMetadata(context, options,
                                                       request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ListRuntimeEntitySchemasResponse>
ConnectorsLogging::ListRuntimeEntitySchemas(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::ListRuntimeEntitySchemasRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::connectors::v1::ListRuntimeEntitySchemasRequest const&
              request) {
        return child_->ListRuntimeEntitySchemas(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::ListRuntimeActionSchemasResponse>
ConnectorsLogging::ListRuntimeActionSchemas(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::ListRuntimeActionSchemasRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::connectors::v1::ListRuntimeActionSchemasRequest const&
              request) {
        return child_->ListRuntimeActionSchemas(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::RuntimeConfig>
ConnectorsLogging::GetRuntimeConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetRuntimeConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::GetRuntimeConfigRequest const&
                 request) {
        return child_->GetRuntimeConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::connectors::v1::Settings>
ConnectorsLogging::GetGlobalSettings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::connectors::v1::GetGlobalSettingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::connectors::v1::GetGlobalSettingsRequest const&
                 request) {
        return child_->GetGlobalSettings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::ListLocationsResponse>
ConnectorsLogging::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::ListLocationsRequest const& request) {
        return child_->ListLocations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::Location> ConnectorsLogging::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return child_->GetLocation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> ConnectorsLogging::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> ConnectorsLogging::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ConnectorsLogging::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::ListOperationsResponse>
ConnectorsLogging::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::ListOperationsRequest const& request) {
        return child_->ListOperations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::Operation> ConnectorsLogging::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->GetOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status ConnectorsLogging::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return child_->DeleteOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status ConnectorsLogging::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->CancelOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ConnectorsLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> ConnectorsLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace connectors_v1_internal
}  // namespace cloud
}  // namespace google
