// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_INTERNAL_CONFIG_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_INTERNAL_CONFIG_CONNECTION_IMPL_H

#include "google/cloud/config/v1/config_connection.h"
#include "google/cloud/config/v1/config_connection_idempotency_policy.h"
#include "google/cloud/config/v1/config_options.h"
#include "google/cloud/config/v1/internal/config_retry_traits.h"
#include "google/cloud/config/v1/internal/config_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace config_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ConfigConnectionImpl : public config_v1::ConfigConnection {
 public:
  ~ConfigConnectionImpl() override = default;

  ConfigConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<config_v1_internal::ConfigStub> stub, Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::config::v1::Deployment> ListDeployments(
      google::cloud::config::v1::ListDeploymentsRequest request) override;

  StatusOr<google::cloud::config::v1::Deployment> GetDeployment(
      google::cloud::config::v1::GetDeploymentRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> CreateDeployment(
      google::cloud::config::v1::CreateDeploymentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateDeployment(
      NoAwaitTag,
      google::cloud::config::v1::CreateDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> CreateDeployment(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> UpdateDeployment(
      google::cloud::config::v1::UpdateDeploymentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateDeployment(
      NoAwaitTag,
      google::cloud::config::v1::UpdateDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> UpdateDeployment(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> DeleteDeployment(
      google::cloud::config::v1::DeleteDeploymentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteDeployment(
      NoAwaitTag,
      google::cloud::config::v1::DeleteDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> DeleteDeployment(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::config::v1::Revision> ListRevisions(
      google::cloud::config::v1::ListRevisionsRequest request) override;

  StatusOr<google::cloud::config::v1::Revision> GetRevision(
      google::cloud::config::v1::GetRevisionRequest const& request) override;

  StatusOr<google::cloud::config::v1::Resource> GetResource(
      google::cloud::config::v1::GetResourceRequest const& request) override;

  StreamRange<google::cloud::config::v1::Resource> ListResources(
      google::cloud::config::v1::ListResourcesRequest request) override;

  StatusOr<google::cloud::config::v1::Statefile> ExportDeploymentStatefile(
      google::cloud::config::v1::ExportDeploymentStatefileRequest const&
          request) override;

  StatusOr<google::cloud::config::v1::Statefile> ExportRevisionStatefile(
      google::cloud::config::v1::ExportRevisionStatefileRequest const& request)
      override;

  StatusOr<google::cloud::config::v1::Statefile> ImportStatefile(
      google::cloud::config::v1::ImportStatefileRequest const& request)
      override;

  Status DeleteStatefile(
      google::cloud::config::v1::DeleteStatefileRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> LockDeployment(
      google::cloud::config::v1::LockDeploymentRequest const& request) override;

  StatusOr<google::longrunning::Operation> LockDeployment(
      NoAwaitTag,
      google::cloud::config::v1::LockDeploymentRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> LockDeployment(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::config::v1::Deployment>> UnlockDeployment(
      google::cloud::config::v1::UnlockDeploymentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UnlockDeployment(
      NoAwaitTag,
      google::cloud::config::v1::UnlockDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::config::v1::Deployment>> UnlockDeployment(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::config::v1::LockInfo> ExportLockInfo(
      google::cloud::config::v1::ExportLockInfoRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Preview>> CreatePreview(
      google::cloud::config::v1::CreatePreviewRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreatePreview(
      NoAwaitTag,
      google::cloud::config::v1::CreatePreviewRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Preview>> CreatePreview(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::config::v1::Preview> GetPreview(
      google::cloud::config::v1::GetPreviewRequest const& request) override;

  StreamRange<google::cloud::config::v1::Preview> ListPreviews(
      google::cloud::config::v1::ListPreviewsRequest request) override;

  future<StatusOr<google::cloud::config::v1::Preview>> DeletePreview(
      google::cloud::config::v1::DeletePreviewRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeletePreview(
      NoAwaitTag,
      google::cloud::config::v1::DeletePreviewRequest const& request) override;

  future<StatusOr<google::cloud::config::v1::Preview>> DeletePreview(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::config::v1::ExportPreviewResultResponse>
  ExportPreviewResult(
      google::cloud::config::v1::ExportPreviewResultRequest const& request)
      override;

  StreamRange<google::cloud::config::v1::TerraformVersion>
  ListTerraformVersions(
      google::cloud::config::v1::ListTerraformVersionsRequest request) override;

  StatusOr<google::cloud::config::v1::TerraformVersion> GetTerraformVersion(
      google::cloud::config::v1::GetTerraformVersionRequest const& request)
      override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<config_v1_internal::ConfigStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_INTERNAL_CONFIG_CONNECTION_IMPL_H
