// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/confidentialcomputing/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIDENTIALCOMPUTING_V1_INTERNAL_CONFIDENTIAL_COMPUTING_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIDENTIALCOMPUTING_V1_INTERNAL_CONFIDENTIAL_COMPUTING_TRACING_CONNECTION_H

#include "google/cloud/confidentialcomputing/v1/confidential_computing_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace confidentialcomputing_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ConfidentialComputingTracingConnection
    : public confidentialcomputing_v1::ConfidentialComputingConnection {
 public:
  ~ConfidentialComputingTracingConnection() override = default;

  explicit ConfidentialComputingTracingConnection(
      std::shared_ptr<confidentialcomputing_v1::ConfidentialComputingConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::confidentialcomputing::v1::Challenge> CreateChallenge(
      google::cloud::confidentialcomputing::v1::CreateChallengeRequest const&
          request) override;

  StatusOr<google::cloud::confidentialcomputing::v1::VerifyAttestationResponse>
  VerifyAttestation(
      google::cloud::confidentialcomputing::v1::VerifyAttestationRequest const&
          request) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

 private:
  std::shared_ptr<confidentialcomputing_v1::ConfidentialComputingConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<confidentialcomputing_v1::ConfidentialComputingConnection>
MakeConfidentialComputingTracingConnection(
    std::shared_ptr<confidentialcomputing_v1::ConfidentialComputingConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace confidentialcomputing_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIDENTIALCOMPUTING_V1_INTERNAL_CONFIDENTIAL_COMPUTING_TRACING_CONNECTION_H
