// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/url_maps/v1/url_maps.proto

#include "google/cloud/compute/url_maps/v1/internal/url_maps_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_url_maps_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

UrlMapsTracingConnection::UrlMapsTracingConnection(
    std::shared_ptr<compute_url_maps_v1::UrlMapsConnection> child)
    : child_(std::move(child)) {}

StreamRange<
    std::pair<std::string, google::cloud::cpp::compute::v1::UrlMapsScopedList>>
UrlMapsTracingConnection::AggregatedListUrlMaps(
    google::cloud::cpp::compute::url_maps::v1::AggregatedListUrlMapsRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::AggregatedListUrlMaps");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListUrlMaps(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::UrlMapsScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::DeleteUrlMap(
    google::cloud::cpp::compute::url_maps::v1::DeleteUrlMapRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::DeleteUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteUrlMap(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsTracingConnection::DeleteUrlMap(
    NoAwaitTag,
    google::cloud::cpp::compute::url_maps::v1::DeleteUrlMapRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::DeleteUrlMap");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteUrlMap(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::DeleteUrlMap(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::DeleteUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteUrlMap(operation));
}

StatusOr<google::cloud::cpp::compute::v1::UrlMap>
UrlMapsTracingConnection::GetUrlMap(
    google::cloud::cpp::compute::url_maps::v1::GetUrlMapRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_url_maps_v1::UrlMapsConnection::GetUrlMap");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetUrlMap(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::InsertUrlMap(
    google::cloud::cpp::compute::url_maps::v1::InsertUrlMapRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::InsertUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertUrlMap(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsTracingConnection::InsertUrlMap(
    NoAwaitTag,
    google::cloud::cpp::compute::url_maps::v1::InsertUrlMapRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::InsertUrlMap");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->InsertUrlMap(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::InsertUrlMap(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::InsertUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertUrlMap(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::InvalidateCache(
    google::cloud::cpp::compute::url_maps::v1::InvalidateCacheRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::InvalidateCache");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InvalidateCache(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsTracingConnection::InvalidateCache(
    NoAwaitTag,
    google::cloud::cpp::compute::url_maps::v1::InvalidateCacheRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::InvalidateCache");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InvalidateCache(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::InvalidateCache(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::InvalidateCache");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InvalidateCache(operation));
}

StreamRange<google::cloud::cpp::compute::v1::UrlMap>
UrlMapsTracingConnection::ListUrlMaps(
    google::cloud::cpp::compute::url_maps::v1::ListUrlMapsRequest request) {
  auto span =
      internal::MakeSpan("compute_url_maps_v1::UrlMapsConnection::ListUrlMaps");
  internal::OTelScope scope(span);
  auto sr = child_->ListUrlMaps(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::UrlMap>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::PatchUrlMap(
    google::cloud::cpp::compute::url_maps::v1::PatchUrlMapRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_url_maps_v1::UrlMapsConnection::PatchUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchUrlMap(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsTracingConnection::PatchUrlMap(
    NoAwaitTag,
    google::cloud::cpp::compute::url_maps::v1::PatchUrlMapRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_url_maps_v1::UrlMapsConnection::PatchUrlMap");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->PatchUrlMap(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::PatchUrlMap(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span =
      internal::MakeSpan("compute_url_maps_v1::UrlMapsConnection::PatchUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchUrlMap(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::UpdateUrlMap(
    google::cloud::cpp::compute::url_maps::v1::UpdateUrlMapRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::UpdateUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateUrlMap(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
UrlMapsTracingConnection::UpdateUrlMap(
    NoAwaitTag,
    google::cloud::cpp::compute::url_maps::v1::UpdateUrlMapRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::UpdateUrlMap");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateUrlMap(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
UrlMapsTracingConnection::UpdateUrlMap(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_url_maps_v1::UrlMapsConnection::UpdateUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateUrlMap(operation));
}

StatusOr<google::cloud::cpp::compute::v1::UrlMapsValidateResponse>
UrlMapsTracingConnection::Validate(
    google::cloud::cpp::compute::url_maps::v1::ValidateRequest const& request) {
  auto span =
      internal::MakeSpan("compute_url_maps_v1::UrlMapsConnection::Validate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Validate(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_url_maps_v1::UrlMapsConnection>
MakeUrlMapsTracingConnection(
    std::shared_ptr<compute_url_maps_v1::UrlMapsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<UrlMapsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_url_maps_v1_internal
}  // namespace cloud
}  // namespace google
