// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/storage_pool_types/v1/storage_pool_types.proto

#include "google/cloud/compute/storage_pool_types/v1/storage_pool_types_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_storage_pool_types_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StoragePoolTypesClient::StoragePoolTypesClient(
    std::shared_ptr<StoragePoolTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
StoragePoolTypesClient::~StoragePoolTypesClient() = default;

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::StoragePoolTypesScopedList>>
StoragePoolTypesClient::AggregatedListStoragePoolTypes(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pool_types::v1::
      AggregatedListStoragePoolTypesRequest request;
  request.set_project(project);
  return connection_->AggregatedListStoragePoolTypes(request);
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::StoragePoolTypesScopedList>>
StoragePoolTypesClient::AggregatedListStoragePoolTypes(
    google::cloud::cpp::compute::storage_pool_types::v1::
        AggregatedListStoragePoolTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListStoragePoolTypes(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesClient::GetStoragePoolType(std::string const& project,
                                           std::string const& zone,
                                           std::string const& storage_pool_type,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pool_types::v1::GetStoragePoolTypeRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool_type(storage_pool_type);
  return connection_->GetStoragePoolType(request);
}

StatusOr<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesClient::GetStoragePoolType(
    google::cloud::cpp::compute::storage_pool_types::v1::
        GetStoragePoolTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetStoragePoolType(request);
}

StreamRange<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesClient::ListStoragePoolTypes(std::string const& project,
                                             std::string const& zone,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pool_types::v1::
      ListStoragePoolTypesRequest request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListStoragePoolTypes(request);
}

StreamRange<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesClient::ListStoragePoolTypes(
    google::cloud::cpp::compute::storage_pool_types::v1::
        ListStoragePoolTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListStoragePoolTypes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_storage_pool_types_v1
}  // namespace cloud
}  // namespace google
