// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/security_policies/v1/security_policies.proto

#include "google/cloud/compute/security_policies/v1/security_policies_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_security_policies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SecurityPoliciesConnectionIdempotencyPolicy::
    ~SecurityPoliciesConnectionIdempotencyPolicy() = default;

std::unique_ptr<SecurityPoliciesConnectionIdempotencyPolicy>
SecurityPoliciesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SecurityPoliciesConnectionIdempotencyPolicy>(*this);
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::AddRule(
    google::cloud::cpp::compute::security_policies::v1::AddRuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SecurityPoliciesConnectionIdempotencyPolicy::AggregatedListSecurityPolicies(
    google::cloud::cpp::compute::security_policies::v1::
        AggregatedListSecurityPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::DeleteSecurityPolicy(
    google::cloud::cpp::compute::security_policies::v1::
        DeleteSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::GetSecurityPolicy(
    google::cloud::cpp::compute::security_policies::v1::
        GetSecurityPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::GetRule(
    google::cloud::cpp::compute::security_policies::v1::GetRuleRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::InsertSecurityPolicy(
    google::cloud::cpp::compute::security_policies::v1::
        InsertSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::ListSecurityPolicies(
    google::cloud::cpp::compute::security_policies::v1::
        ListSecurityPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
SecurityPoliciesConnectionIdempotencyPolicy::ListPreconfiguredExpressionSets(
    google::cloud::cpp::compute::security_policies::v1::
        ListPreconfiguredExpressionSetsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::PatchSecurityPolicy(
    google::cloud::cpp::compute::security_policies::v1::
        PatchSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::PatchRule(
    google::cloud::cpp::compute::security_policies::v1::
        PatchRuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::RemoveRule(
    google::cloud::cpp::compute::security_policies::v1::
        RemoveRuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityPoliciesConnectionIdempotencyPolicy::SetLabels(
    google::cloud::cpp::compute::security_policies::v1::
        SetLabelsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SecurityPoliciesConnectionIdempotencyPolicy>
MakeDefaultSecurityPoliciesConnectionIdempotencyPolicy() {
  return std::make_unique<SecurityPoliciesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_security_policies_v1
}  // namespace cloud
}  // namespace google
