// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instance_settings/v1/instance_settings.proto

#include "google/cloud/compute/instance_settings/v1/instance_settings_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instance_settings_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstanceSettingsClient::InstanceSettingsClient(
    std::shared_ptr<InstanceSettingsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
InstanceSettingsClient::~InstanceSettingsClient() = default;

StatusOr<google::cloud::cpp::compute::v1::InstanceSettings>
InstanceSettingsClient::GetInstanceSettings(std::string const& project,
                                            std::string const& zone,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_settings::v1::GetInstanceSettingsRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->GetInstanceSettings(request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceSettings>
InstanceSettingsClient::GetInstanceSettings(
    google::cloud::cpp::compute::instance_settings::v1::
        GetInstanceSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstanceSettings(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceSettingsClient::PatchInstanceSettings(
    std::string const& project, std::string const& zone,
    std::string const& update_mask,
    google::cloud::cpp::compute::v1::InstanceSettings const&
        instance_settings_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_settings::v1::
      PatchInstanceSettingsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_update_mask(update_mask);
  *request.mutable_instance_settings_resource() = instance_settings_resource;
  return connection_->PatchInstanceSettings(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceSettingsClient::PatchInstanceSettings(
    NoAwaitTag, std::string const& project, std::string const& zone,
    std::string const& update_mask,
    google::cloud::cpp::compute::v1::InstanceSettings const&
        instance_settings_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_settings::v1::
      PatchInstanceSettingsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_update_mask(update_mask);
  *request.mutable_instance_settings_resource() = instance_settings_resource;
  return connection_->PatchInstanceSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceSettingsClient::PatchInstanceSettings(
    google::cloud::cpp::compute::instance_settings::v1::
        PatchInstanceSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchInstanceSettings(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceSettingsClient::PatchInstanceSettings(
    NoAwaitTag,
    google::cloud::cpp::compute::instance_settings::v1::
        PatchInstanceSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchInstanceSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceSettingsClient::PatchInstanceSettings(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchInstanceSettings(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_settings_v1
}  // namespace cloud
}  // namespace google
