// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/instance_group_managers/v1/instance_group_managers.proto

#include "google/cloud/compute/instance_group_managers/v1/internal/instance_group_managers_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instance_group_managers_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstanceGroupManagersRestMetadata::InstanceGroupManagersRestMetadata(
    std::shared_ptr<InstanceGroupManagersRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncAbandonInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        AbandonInstancesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncAbandonInstances(cq, std::move(rest_context),
                                       std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::AbandonInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        AbandonInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AbandonInstances(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManagerAggregatedList>
InstanceGroupManagersRestMetadata::AggregatedListInstanceGroupManagers(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        AggregatedListInstanceGroupManagersRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AggregatedListInstanceGroupManagers(rest_context, options,
                                                     request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncApplyUpdatesToInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ApplyUpdatesToInstancesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncApplyUpdatesToInstances(cq, std::move(rest_context),
                                              std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::ApplyUpdatesToInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ApplyUpdatesToInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ApplyUpdatesToInstances(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncCreateInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        CreateInstancesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCreateInstances(cq, std::move(rest_context),
                                      std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::CreateInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        CreateInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->CreateInstances(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncDeleteInstanceGroupManager(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstanceGroupManagerRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteInstanceGroupManager(cq, std::move(rest_context),
                                                 std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::DeleteInstanceGroupManager(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstanceGroupManagerRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteInstanceGroupManager(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncDeleteInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstancesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteInstances(cq, std::move(rest_context),
                                      std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::DeleteInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteInstances(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncDeletePerInstanceConfigs(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeletePerInstanceConfigsRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeletePerInstanceConfigs(cq, std::move(rest_context),
                                               std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::DeletePerInstanceConfigs(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeletePerInstanceConfigsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeletePerInstanceConfigs(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManager>
InstanceGroupManagersRestMetadata::GetInstanceGroupManager(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        GetInstanceGroupManagerRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetInstanceGroupManager(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncInsertInstanceGroupManager(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        InsertInstanceGroupManagerRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertInstanceGroupManager(cq, std::move(rest_context),
                                                 std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::InsertInstanceGroupManager(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        InsertInstanceGroupManagerRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertInstanceGroupManager(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManagerList>
InstanceGroupManagersRestMetadata::ListInstanceGroupManagers(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListInstanceGroupManagersRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListInstanceGroupManagers(rest_context, options, request);
}

StatusOr<
    google::cloud::cpp::compute::v1::InstanceGroupManagersListErrorsResponse>
InstanceGroupManagersRestMetadata::ListErrors(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListErrorsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListErrors(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::
             InstanceGroupManagersListManagedInstancesResponse>
InstanceGroupManagersRestMetadata::ListManagedInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListManagedInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListManagedInstances(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::
             InstanceGroupManagersListPerInstanceConfigsResp>
InstanceGroupManagersRestMetadata::ListPerInstanceConfigs(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListPerInstanceConfigsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListPerInstanceConfigs(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncPatchInstanceGroupManager(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchInstanceGroupManagerRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchInstanceGroupManager(cq, std::move(rest_context),
                                                std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::PatchInstanceGroupManager(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchInstanceGroupManagerRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchInstanceGroupManager(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncPatchPerInstanceConfigs(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchPerInstanceConfigsRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchPerInstanceConfigs(cq, std::move(rest_context),
                                              std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::PatchPerInstanceConfigs(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchPerInstanceConfigsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchPerInstanceConfigs(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncRecreateInstances(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        RecreateInstancesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncRecreateInstances(cq, std::move(rest_context),
                                        std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::RecreateInstances(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        RecreateInstancesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->RecreateInstances(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncResize(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ResizeRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncResize(cq, std::move(rest_context), std::move(options),
                             request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::Resize(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        ResizeRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->Resize(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncSetInstanceTemplate(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetInstanceTemplateRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetInstanceTemplate(cq, std::move(rest_context),
                                          std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::SetInstanceTemplate(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetInstanceTemplateRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetInstanceTemplate(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncSetTargetPools(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetTargetPoolsRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetTargetPools(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::SetTargetPools(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetTargetPoolsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetTargetPools(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncUpdatePerInstanceConfigs(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        UpdatePerInstanceConfigsRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncUpdatePerInstanceConfigs(cq, std::move(rest_context),
                                               std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagersRestMetadata::UpdatePerInstanceConfigs(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::instance_group_managers::v1::
        UpdatePerInstanceConfigsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UpdatePerInstanceConfigs(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::GetOperationRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> InstanceGroupManagersRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void InstanceGroupManagersRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_group_managers_v1_internal
}  // namespace cloud
}  // namespace google
